/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.spawns;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.spawns.Spawn;
import su.nightexpress.sunlight.module.spawns.command.SpawnCommands;
import su.nightexpress.sunlight.module.spawns.config.SpawnsLang;
import su.nightexpress.sunlight.module.spawns.config.SpawnsPerms;
import su.nightexpress.sunlight.module.spawns.config.SpawnsSettings;
import su.nightexpress.sunlight.module.spawns.dialog.SpawnsDialogKeys;
import su.nightexpress.sunlight.module.spawns.dialog.impl.SpawnNameDialog;
import su.nightexpress.sunlight.module.spawns.dialog.impl.SpawnPriorityDialog;
import su.nightexpress.sunlight.module.spawns.dialog.impl.SpawnRulesDialog;
import su.nightexpress.sunlight.module.spawns.editor.SpawnListEditor;
import su.nightexpress.sunlight.module.spawns.editor.SpawnSettingsEditor;
import su.nightexpress.sunlight.module.spawns.event.PlayerSpawnTeleportEvent;
import su.nightexpress.sunlight.module.spawns.listener.SpawnListener;
import su.nightexpress.sunlight.teleport.TeleportContext;
import su.nightexpress.sunlight.teleport.TeleportFlag;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.teleport.TeleportType;
import su.nightexpress.sunlight.user.SunUser;

public class SpawnsModule
extends Module {
    private final TeleportManager teleportManager;
    private final SpawnsSettings settings;
    private final Map<String, Spawn> spawnMap;
    private SpawnListEditor listEditor;
    private SpawnSettingsEditor settingsEditor;

    public SpawnsModule(@NotNull ModuleContext context, @NotNull TeleportManager teleportManager) {
        super(context);
        this.teleportManager = teleportManager;
        this.settings = new SpawnsSettings();
        this.spawnMap = new HashMap<String, Spawn>();
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        ((SunLightPlugin)this.plugin).injectLang(SpawnsLang.class);
        this.loadDialogs();
        this.loadSpawns();
        this.listEditor = new SpawnListEditor((SunLightPlugin)this.plugin, this);
        this.settingsEditor = new SpawnSettingsEditor((SunLightPlugin)this.plugin, this, this.dialogRegistry);
        this.addListener((SimpeListener)new SpawnListener((SunLightPlugin)this.plugin, this));
        this.addAsyncTask(this::saveSpawns, 60);
    }

    @Override
    protected void unloadModule() {
        this.saveSpawns();
        this.spawnMap.clear();
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(SpawnsPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("spawn", new SpawnCommands((SunLightPlugin)this.plugin, this, this.userManager));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    private void loadDialogs() {
        this.dialogRegistry.register(SpawnsDialogKeys.SPAWN_NAME, SpawnNameDialog::new);
        this.dialogRegistry.register(SpawnsDialogKeys.SPAWN_PRIORITY, SpawnPriorityDialog::new);
        this.dialogRegistry.register(SpawnsDialogKeys.SPAWN_LOGIN_RULES, () -> new SpawnRulesDialog(Spawn::getLoginRule));
        this.dialogRegistry.register(SpawnsDialogKeys.SPAWN_RESPAWN_RULES, () -> new SpawnRulesDialog(Spawn::getRespawnRule));
    }

    private void loadSpawns() {
        FileUtil.findYamlFiles((String)(this.getSystemPath() + "/spawns/")).forEach(file -> {
            String name = FileUtil.getNameWithoutExtension((Path)file);
            String id = Strings.varStyle((String)name).orElse(null);
            if (id == null) {
                this.error("Invalid spawn file name: '%s'".formatted(file));
                return;
            }
            Spawn spawn = new Spawn(id, (Path)file);
            this.loadSpawn(spawn);
        });
        this.info("Loaded " + this.spawnMap.size() + " spawns!");
    }

    private void loadSpawn(@NotNull Spawn spawn) {
        try {
            spawn.load();
            spawn.activate();
            this.spawnMap.put(spawn.getId(), spawn);
        }
        catch (IllegalStateException exception) {
            exception.printStackTrace();
            this.warn("Spawn not loaded: '" + String.valueOf(spawn.getFile()) + "'!");
        }
    }

    private void saveSpawns() {
        this.getSpawns().forEach(Spawn::saveIfDirty);
    }

    public void openEditor(@NotNull Player player) {
        this.listEditor.show((NightPlugin)this.plugin, player);
    }

    public void openSpawnSettings(@NotNull Player player, @NotNull Spawn spawn) {
        this.settingsEditor.show((NightPlugin)this.plugin, player, spawn);
    }

    @NotNull
    public Map<String, Spawn> getSpawnMap() {
        return Map.copyOf(this.spawnMap);
    }

    @NotNull
    public Set<Spawn> getSpawns() {
        return Set.copyOf(this.spawnMap.values());
    }

    @NotNull
    public List<String> getSpawnIds() {
        return new ArrayList<String>(this.spawnMap.keySet());
    }

    @Nullable
    public Spawn getSpawn(@NotNull String id) {
        return this.spawnMap.get(id.toLowerCase());
    }

    @Nullable
    public Spawn getDefaultSpawn() {
        return this.getSpawn(this.settings.getDefaultSpawnId());
    }

    @Nullable
    public Spawn getSpawnOrDefault(@NotNull String id) {
        return this.spawnMap.getOrDefault(id.toLowerCase(), this.getDefaultSpawn());
    }

    @Nullable
    public Spawn getNewbieSpawn(@NotNull Player player) {
        return this.getSpawn(this.settings.getNewPlayersSpawnId());
    }

    @Nullable
    public Spawn getLoginSpawn(@NotNull Player player) {
        return this.getSpawns().stream().filter(spawn -> spawn.isAvailableForJoin(player)).max(Comparator.comparingInt(Spawn::getPriority)).orElse(null);
    }

    @Nullable
    public Spawn getDeathSpawn(@NotNull Player player) {
        return this.getSpawns().stream().filter(spawn -> spawn.isAvailableForRespawn(player)).max(Comparator.comparingInt(Spawn::getPriority)).orElse(null);
    }

    public boolean createSpawn(@NotNull Player player, @NotNull String id) {
        Location location = player.getLocation();
        Spawn spawn = this.getSpawn(id = StringUtil.lowerCaseUnderscore((String)id));
        if (spawn == null) {
            Path file = Path.of(this.getSystemPath() + "/spawns/", id + ".yml");
            spawn = new Spawn(id, file);
            spawn.setName(StringUtil.capitalizeUnderscored((String)id));
        }
        spawn.setLocation(location);
        spawn.save();
        this.loadSpawn(spawn);
        Spawn finalSpawn = spawn;
        this.sendPrefixed(SpawnsLang.SPAWN_SET_FEEDBACK, (CommandSender)player, (PlaceholderContext.Builder replacer) -> replacer.with(finalSpawn.placeholders()));
        return true;
    }

    public boolean deleteSpawn(@NotNull Spawn spawn) {
        try {
            if (Files.deleteIfExists(spawn.getFile())) {
                this.spawnMap.remove(spawn.getId());
                return true;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public void handleJoin(@NotNull PlayerJoinEvent event) {
        Spawn spawn;
        Player player = event.getPlayer();
        SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
        if (!user.hasPlayedBefore()) {
            if (!this.settings.isNewPlayersSpawnEnabled()) {
                return;
            }
            spawn = this.getNewbieSpawn(player);
        } else {
            spawn = this.getLoginSpawn(player);
        }
        if (spawn == null || !spawn.isActive()) {
            return;
        }
        this.teleport(spawn, player, true, true);
    }

    public void handleRespawn(@NotNull PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (player.getRespawnLocation() != null && !this.settings.isOverridePlayerRespawnLocation()) {
            return;
        }
        Spawn spawn = this.getDeathSpawn(player);
        if (spawn == null || !spawn.isActive()) {
            return;
        }
        event.setRespawnLocation(spawn.getLocation());
    }

    public void teleport(@NotNull Spawn spawn, @NotNull Player player) {
        this.teleport(spawn, player, true, false);
    }

    public boolean teleport(@NotNull Spawn spawn, @NotNull Player player, boolean forced, boolean silent) {
        if (!spawn.isActive()) {
            if (!silent) {
                SpawnsLang.ERROR_SPAWN_INACTIVE.message().send((CommandSender)player);
            }
            return false;
        }
        if (!forced && !spawn.hasPermission(player)) {
            if (!silent) {
                this.sendPrefixed(CoreLang.ERROR_NO_PERMISSION, (CommandSender)player);
            }
            return false;
        }
        PlayerSpawnTeleportEvent event = new PlayerSpawnTeleportEvent(player, spawn);
        ((SunLightPlugin)this.plugin).getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        Location location = spawn.getLocation();
        TeleportContext teleportContext = TeleportContext.builder(this, player, location).withFlag(TeleportFlag.LOOK_FOR_SURFACE).withFlag(TeleportFlag.AVOID_LAVA).withFlag(TeleportFlag.CENTERED).withFlagIf(TeleportFlag.BYPASS_WARMUP, () -> forced).callback(() -> {
            if (!silent) {
                this.sendPrefixed(SpawnsLang.SPAWN_TELEPORT_NOTIFY, (CommandSender)player, (PlaceholderContext.Builder replacer) -> replacer.with(spawn.placeholders()));
            }
        }).build();
        return this.teleportManager.teleport(teleportContext, TeleportType.SPAWN);
    }
}

