/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.scoreboard;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.scoreboard.ScoreboardDefaults;
import su.nightexpress.sunlight.module.scoreboard.ScoreboardProperties;
import su.nightexpress.sunlight.module.scoreboard.board.Board;
import su.nightexpress.sunlight.module.scoreboard.board.BoardDefinition;
import su.nightexpress.sunlight.module.scoreboard.board.BoardProvider;
import su.nightexpress.sunlight.module.scoreboard.board.impl.PacketBoard;
import su.nightexpress.sunlight.module.scoreboard.board.impl.ProtocolBoard;
import su.nightexpress.sunlight.module.scoreboard.command.ScoreboardCommand;
import su.nightexpress.sunlight.module.scoreboard.config.SBConfig;
import su.nightexpress.sunlight.module.scoreboard.config.SBLang;
import su.nightexpress.sunlight.module.scoreboard.config.SBPerms;
import su.nightexpress.sunlight.module.scoreboard.listener.ScoreboardListener;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;
import su.nightexpress.sunlight.utils.DynamicText;

public class ScoreboardModule
extends Module {
    private final SBConfig settings = new SBConfig();
    private final Map<String, DynamicText> animationMap = new HashMap<String, DynamicText>();
    private final Map<Player, Board> boardMap = new ConcurrentHashMap<Player, Board>();
    private BoardProvider provider;

    public ScoreboardModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        ((SunLightPlugin)this.plugin).injectLang(SBLang.class);
        UserPropertyRegistry.register(ScoreboardProperties.SCOREBOARD);
        this.loadAnimations();
        this.loadProvider();
        this.addListener((SimpeListener)new ScoreboardListener((SunLightPlugin)this.plugin, this));
        this.addAsyncTask(this::updateBoards, 1L);
        ((SunLightPlugin)this.plugin).runTask(task -> this.loadPlayerBoards());
    }

    @Override
    protected void unloadModule() {
        this.boardMap.values().forEach(Board::remove);
        this.boardMap.clear();
        this.animationMap.clear();
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(SBPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("scoreboard", new ScoreboardCommand((SunLightPlugin)this.plugin, this, this.userManager));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
        registry.register("scoreboard_state", (player, payload) -> CoreLang.STATE_YES_NO.get(this.isScoreboardEnabled(player)));
    }

    private void loadProvider() {
        if (Plugins.isInstalled((String)"packetevents")) {
            this.provider = PacketBoard::new;
        } else if (Plugins.isInstalled((String)"ProtocolLib")) {
            this.provider = ProtocolBoard::new;
        }
    }

    private void loadAnimations() {
        FileConfig config = FileConfig.load((String)this.getSystemPath(), (String)"animations.yml");
        if (config.getSection("").isEmpty()) {
            ScoreboardDefaults.getDefaultAnimations().forEach(dynamicText -> dynamicText.write(config, dynamicText.getId()));
        }
        for (String sId : config.getSection("")) {
            DynamicText dynamicText2 = DynamicText.read(config, sId, sId);
            this.animationMap.put(dynamicText2.getId(), dynamicText2);
        }
        config.saveChanges();
    }

    private void loadPlayerBoards() {
        ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers().forEach(player -> {
            if (this.isScoreboardEnabled((Player)player)) {
                this.addBoard((Player)player);
            }
        });
    }

    @Nullable
    public BoardDefinition getBoardDefinition(@NotNull Player player) {
        return this.settings.getBoardDefinitionMap().values().stream().filter(board -> board.isAvailable(player)).max(Comparator.comparingInt(BoardDefinition::getPriority)).orElse(null);
    }

    @NotNull
    public Set<DynamicText> getAnimations() {
        return Set.copyOf(this.animationMap.values());
    }

    @NotNull
    public Map<Player, Board> getBoardMap() {
        return Map.copyOf(this.boardMap);
    }

    @NotNull
    public Set<Board> getBoards() {
        return Set.copyOf(this.boardMap.values());
    }

    @Nullable
    public Board getBoard(@NotNull Player player) {
        return this.boardMap.get(player);
    }

    public void updateBoards() {
        if (this.boardMap.isEmpty()) {
            return;
        }
        this.getBoards().forEach(Board::updateIfReady);
    }

    public boolean hasBoard(@NotNull Player player) {
        return this.getBoard(player) != null;
    }

    public void addBoard(@NotNull Player player) {
        BoardDefinition boardDefinition = this.getBoardDefinition(player);
        if (boardDefinition == null) {
            return;
        }
        this.addBoard(player, boardDefinition);
    }

    public synchronized void addBoard(@NotNull Player player, @NotNull BoardDefinition boardDefinition) {
        if (this.provider == null) {
            return;
        }
        if (this.hasBoard(player)) {
            return;
        }
        this.boardMap.computeIfAbsent(player, k -> this.provider.create(player, this.createPlaceholderContext(player), boardDefinition)).create();
    }

    public synchronized void removeBoard(@NotNull Player player) {
        Board board = this.boardMap.remove(player);
        if (board == null) {
            return;
        }
        board.remove();
    }

    public void toggleBoard(@NotNull Player player) {
        if (!this.hasBoard(player)) {
            this.addBoard(player);
        } else {
            this.removeBoard(player);
        }
    }

    public boolean isScoreboardEnabled(@NotNull Player player) {
        SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
        return user.getPropertyOrDefault(ScoreboardProperties.SCOREBOARD);
    }

    @NotNull
    private PlaceholderContext createPlaceholderContext(@NotNull Player player) {
        PlaceholderContext.Builder builder = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver((Object)player)).andThen(CommonPlaceholders.forPlaceholderAPI((Player)player));
        for (DynamicText animator : this.getAnimations()) {
            builder.with(SLPlaceholders.ANIMATION.apply(animator.getId()), animator::getMessage);
        }
        return builder.build();
    }
}

