/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.scheduler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.exception.ModuleLoadException;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.scheduler.SchedulerDefaults;
import su.nightexpress.sunlight.module.scheduler.SchedulerSettings;
import su.nightexpress.sunlight.module.scheduler.announcer.Announcer;

public class SchedulerModule
extends Module {
    private final SchedulerSettings settings = new SchedulerSettings();
    private final Map<String, Announcer> announcerByIdMap = new HashMap<String, Announcer>();

    public SchedulerModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) throws ModuleLoadException {
        this.settings.load(config);
        this.loadAnnouncers();
        this.getAnnouncers().forEach(announcer -> this.addAsyncTask(() -> this.broadcastAnnouncer((Announcer)announcer), announcer.getInterval()));
    }

    @Override
    protected void unloadModule() {
        this.announcerByIdMap.clear();
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    @NotNull
    public SchedulerSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public Set<Announcer> getAnnouncers() {
        return Set.copyOf(this.announcerByIdMap.values());
    }

    private void loadAnnouncers() {
        Path dirPath = Path.of(this.getSystemPath(), "/announcers/");
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
                SchedulerDefaults.getDefaultAnnouncers().forEach((id, announcer) -> {
                    Path filePath = Path.of(dirPath.toString(), FileConfig.withExtension((String)id));
                    announcer.writeToFile(filePath);
                });
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        FileUtil.findYamlFiles((String)dirPath.toString()).forEach(filePath -> {
            String name = FileUtil.getNameWithoutExtension((Path)filePath);
            String id = Strings.varStyle((String)name).orElse(null);
            if (id == null) {
                this.error("Could not load '%s' announcer: Invalid file name.".formatted(filePath.toString()));
                return;
            }
            Announcer announcer = Announcer.fromFile(filePath);
            this.announcerByIdMap.put(id, announcer);
        });
        this.info("Loaded " + this.announcerByIdMap.size() + " announcers.");
    }

    public void broadcastAnnouncer(@NotNull Announcer announcer) {
        String message = announcer.selectMessage();
        if (message == null) {
            return;
        }
        Players.getOnline().forEach(player -> {
            PlaceholderContext context = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver(player)).andThen(CommonPlaceholders.forPlaceholderAPI((Player)player)).build();
            Players.sendMessage((CommandSender)player, (String)context.apply(message));
        });
    }
}

