/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.rtp;

import java.util.Optional;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.random.Rnd;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.rtp.command.RTPCommandProvider;
import su.nightexpress.sunlight.module.rtp.config.RTPLang;
import su.nightexpress.sunlight.module.rtp.config.RTPPerms;
import su.nightexpress.sunlight.module.rtp.config.RTPSettings;
import su.nightexpress.sunlight.module.rtp.model.LookupRange;
import su.nightexpress.sunlight.teleport.TeleportContext;
import su.nightexpress.sunlight.teleport.TeleportFlag;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.teleport.TeleportType;

public class RTPModule
extends Module {
    private final TeleportManager teleportManager;
    private final RTPSettings settings;

    public RTPModule(@NotNull ModuleContext context, @NotNull TeleportManager teleportManager) {
        super(context);
        this.teleportManager = teleportManager;
        this.settings = new RTPSettings();
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        ((SunLightPlugin)this.plugin).injectLang(RTPLang.class);
    }

    @Override
    protected void unloadModule() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(RTPPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("rtp", new RTPCommandProvider((SunLightPlugin)this.plugin, this));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    public boolean teleportToRandomPlace(@NotNull Player player) {
        World fallbackWorld;
        World world = player.getWorld();
        LookupRange lookupRange = this.getWorldRange(world.getName());
        if (lookupRange == null && this.settings.isFallbackEnabled() && (fallbackWorld = ((SunLightPlugin)this.plugin).getServer().getWorld(this.settings.getFallbackWorld())) != null) {
            world = fallbackWorld;
            lookupRange = this.getWorldRange(fallbackWorld.getName());
        }
        if (lookupRange == null) {
            this.sendPrefixed(RTPLang.TELEPORT_ERROR_INVALID_RANGE, (CommandSender)player);
            return false;
        }
        int maxErrors = this.settings.getLookupMaxAttempts();
        Location location = null;
        for (int errorCount = 0; errorCount < maxErrors && (location = (Location)this.pickLocation(world, lookupRange).orElse(null)) == null; ++errorCount) {
        }
        if (location == null) {
            this.sendPrefixed(RTPLang.RANDOM_LOCATION_TELEPORT_FAILURE, (CommandSender)player);
            return false;
        }
        Location destination = location.clone();
        TeleportContext teleportContext = TeleportContext.builder(this, player, destination).withFlag(TeleportFlag.CENTERED).withFlag(TeleportFlag.KEEP_DIRECTION).withFlag(TeleportFlag.AVOID_LAVA).callback(() -> this.sendPrefixed(RTPLang.RANDOM_LOCATION_TELEPORT_SUCCESS, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.LOCATION.resolver((Object)destination)))).build();
        return this.teleportManager.teleport(teleportContext, TeleportType.RTP);
    }

    @Nullable
    public LookupRange getWorldRange(@NotNull String name) {
        return this.settings.getLookupRangesMap().get(LowerCase.INTERNAL.apply(name));
    }

    @NotNull
    public Optional<Location> pickLocation(@NotNull World world, @NotNull LookupRange lookupRange) {
        int bY;
        int locZ;
        int chunkZ;
        Set<BlockFace> directions = lookupRange.getDirections();
        Set directionsX = Lists.newSet((Object[])new BlockFace[]{BlockFace.EAST, BlockFace.WEST});
        Set directionsZ = Lists.newSet((Object[])new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH});
        directionsX.retainAll(directions);
        directionsZ.retainAll(directions);
        if (directionsX.isEmpty() && directionsZ.isEmpty()) {
            return Optional.empty();
        }
        int distanceX = Rnd.get((int)lookupRange.getDistanceMin(), (int)lookupRange.getDistanceMax());
        int distanceZ = Rnd.get((int)lookupRange.getDistanceMin(), (int)lookupRange.getDistanceMax());
        BlockFace directionX = directionsX.isEmpty() ? BlockFace.UP : (BlockFace)Rnd.get((Set)directionsX);
        BlockFace directionZ = directionsZ.isEmpty() ? BlockFace.UP : (BlockFace)Rnd.get((Set)directionsZ);
        int locX = lookupRange.getStartX() + directionX.getModX() * distanceX;
        int chunkX = locX >> 4;
        Chunk chunk = world.getChunkAt(chunkX, chunkZ = (locZ = lookupRange.getStartZ() + directionZ.getModZ() * distanceZ) >> 4, false);
        if (!chunk.isGenerated() && this.settings.isLookupGeneratedChunksOnly()) {
            return Optional.empty();
        }
        if (!chunk.isLoaded() && this.settings.isLookupLoadedChunksOnly()) {
            return Optional.empty();
        }
        ChunkSnapshot snapshot = chunk.getChunkSnapshot();
        int bX = locX & 0xF;
        int bZ = locZ & 0xF;
        if (world.getEnvironment() == World.Environment.NETHER) {
            int start = world.getMinHeight();
            int end = snapshot.getHighestBlockYAt(bX, bZ);
            Integer found = null;
            boolean wasAir = false;
            for (int y = end; y > start; --y) {
                Material blockType = snapshot.getBlockType(bX, y, bZ);
                if (wasAir && blockType.isBlock() && blockType.isSolid() && blockType != Material.BEDROCK) {
                    found = y;
                    break;
                }
                wasAir = blockType.isAir();
            }
            if (found == null) {
                return Optional.empty();
            }
            bY = found;
        } else {
            bY = snapshot.getHighestBlockYAt(bX, bZ);
        }
        Material material = snapshot.getBlockType(bX, bY, bZ);
        if (!material.isBlock() || !material.isSolid()) {
            return Optional.empty();
        }
        return Optional.of(new Location(world, (double)locX, (double)(bY + 1), (double)locZ));
    }
}

