/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.menu;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.action.MenuItemAction;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsModule;
import su.nightexpress.sunlight.module.playerwarps.category.NormalCategory;
import su.nightexpress.sunlight.module.playerwarps.category.WarpCategory;
import su.nightexpress.sunlight.module.playerwarps.core.PlayerWarpsSettings;
import su.nightexpress.sunlight.module.playerwarps.featuring.FeaturedData;
import su.nightexpress.sunlight.module.playerwarps.featuring.FeaturedSlot;

public class PlayerWarpsMainMenu
extends AbstractMenu
implements LangContainer {
    private static final IconLocale ICON_CATEGORY = LangEntry.iconBuilder((String)"PlayerWarps.UI.MainMenu.WarpCategory").rawName("%category_name%").rawLore(new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Warps: " + TagWrappers.WHITE.wrap("%amount%")), "", "%category_description%", "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to browse"))}).build();
    private static final IconLocale ICON_FEATURED_WARP = LangEntry.iconBuilder((String)"PlayerWarps.UI.MainMenu.FeaturedWarp").rawName(TagWrappers.YELLOW.wrap("\u2b50") + " %warp_name% " + TagWrappers.YELLOW.wrap("\u2b50")).rawLore(new String[]{TagWrappers.YELLOW.wrap("Featured: %time%"), "", TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Owner: " + TagWrappers.WHITE.wrap("%warp_owner_name%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Visits: " + TagWrappers.WHITE.wrap("%warp_visits%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Description:"), "%warp_description%", "", TagWrappers.YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to teleport"))}).build();
    private static final IconLocale ICON_POPULAR_WARP = LangEntry.iconBuilder((String)"PlayerWarps.UI.MainMenu.PopularWarp").rawName(TagWrappers.SOFT_AQUA.wrap("[Top #%value%]") + " %warp_name%").rawLore(new String[]{TagWrappers.SOFT_AQUA.wrap("Most Visited Warp #%value%"), "", TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Owner: " + TagWrappers.WHITE.wrap("%warp_owner_name%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Visits: " + TagWrappers.WHITE.wrap("%warp_visits%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Description:"), "%warp_description%", "", TagWrappers.SOFT_AQUA.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to teleport"))}).build();
    private final PlayerWarpsModule module;
    private final PlayerWarpsSettings settings;
    private final MenuItemAction viewOwnAction;
    private final MenuItemAction viewAllAction;
    private ItemPopulator<NormalCategory> categoryPopulator;
    private NightItem featuredIcon;
    private NightItem popularIcon;

    public PlayerWarpsMainMenu(@NotNull PlayerWarpsModule module, @NonNull PlayerWarpsSettings settings) {
        super((MenuType)MenuType.GENERIC_9X6, "Player Warps");
        this.module = module;
        this.settings = settings;
        this.viewOwnAction = this::viewOwnWarps;
        this.viewAllAction = this::viewAllWarps;
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(0, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(45, 54).toArray());
        this.addBackgroundItem(Material.GRAY_STAINED_GLASS_PANE, IntStream.range(19, 26).toArray());
        this.addBackgroundItem(Material.GRAY_STAINED_GLASS_PANE, IntStream.range(28, 35).toArray());
        this.addDefaultButton("view_own", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.PLAYER_HEAD).setDisplayName(TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("View Own Warps")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Warps: ") + TagWrappers.WHITE.wrap("%amount%")), "", TagWrappers.GRAY.wrap("View all warps created by you."), "", TagWrappers.GREEN.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to open"))})).hideAllComponents()).displayModifier((context, item) -> item.setPlayerProfile((OfflinePlayer)context.getPlayer()).replace(builder -> builder.with("%amount%", () -> NumberUtil.format((double)this.module.getRepository().countOwnedWarps(context.getPlayer().getUniqueId()))))).action(this.viewOwnAction).build()).slots(new int[]{45}).build());
        this.addDefaultButton("view_all", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ENDER_EYE).setDisplayName(TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("View All Warps")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Warps: ") + TagWrappers.WHITE.wrap("%amount%")), "", TagWrappers.GRAY.wrap("View all the player warps."), "", TagWrappers.GREEN.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to open"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with("%amount%", () -> NumberUtil.format((double)this.module.getRepository().size())))).action(this.viewAllAction).build()).slots(new int[]{53}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
        int[] categorySlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Category.Slots", (Object)new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}, (String[])new String[0]).resolveWithDefaults(config);
        this.categoryPopulator = ItemPopulator.builder(NormalCategory.class).itemProvider((context, category) -> category.icon().hideAllComponents().localized(ICON_CATEGORY).replace(builder -> builder.with(category.placeholders()).with("%amount%", () -> NumberUtil.format((double)this.module.getRepository().countWarps((WarpCategory)category))))).actionProvider(category -> context -> this.viewWarps((ViewerContext)context, (NormalCategory)category)).slots(categorySlots).build();
        this.featuredIcon = (NightItem)ConfigProperty.of((ConfigType)ConfigTypes.NIGHT_ITEM, (String)"Featured.Icon", (Object)NightItem.fromType((Material)Material.YELLOW_DYE).setDisplayName(TagWrappers.YELLOW.wrap("\u2b50" + TagWrappers.BOLD.wrap(" Featured Slot ") + "\u2b50")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Purchase this slot for " + TagWrappers.YELLOW.wrap("%slot_price%") + " to"), TagWrappers.GRAY.wrap("feature your warp for " + TagWrappers.WHITE.wrap("%slot_duration%") + "!"), "", TagWrappers.YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to purchase"))})), (String[])new String[0]).resolveWithDefaults(config);
        this.popularIcon = (NightItem)ConfigProperty.of((ConfigType)ConfigTypes.NIGHT_ITEM, (String)"Popular.Icon", (Object)NightItem.fromType((Material)Material.GRAY_DYE).setDisplayName(TagWrappers.GRAY.wrap("Most Visited Warp #%value%")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Nothing yet.")})), (String[])new String[0]).resolveWithDefaults(config);
    }

    private void viewWarps(@NonNull ViewerContext context, @NonNull NormalCategory category) {
        this.module.openWarpsList(context.getPlayer(), category, null, null);
    }

    private void viewOwnWarps(@NonNull ViewerContext context) {
        this.module.openOwnWarpsList(context.getPlayer(), context.getPlayer().getUniqueId());
    }

    private void viewAllWarps(@NonNull ViewerContext context) {
        this.module.openAllWarpsList(context.getPlayer());
    }

    private void displayFeaturedWarps(@NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        HashSet usedSlots = new HashSet();
        this.module.getRepository().getFeaturedWarps().forEach(warp -> {
            int[] inventorySlots;
            FeaturedData data = warp.getFeaturedData();
            if (data == null || !data.isActive()) {
                return;
            }
            FeaturedSlot slot = this.settings.getFeaturingSlot(data.slotId());
            if (slot == null) {
                return;
            }
            int slotIndex = data.slotIndex();
            if (slotIndex >= (inventorySlots = slot.inventorySlots()).length) {
                return;
            }
            int inventorySlot = inventorySlots[slotIndex];
            if (inventorySlot >= inventory.getSize()) {
                return;
            }
            items.add(MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(warp.getIcon().localized(ICON_FEATURED_WARP).replace(builder -> builder.with(warp.placeholders()).with("%time%", () -> TimeFormats.formatDuration((long)data.endTimestamp(), (TimeFormatType)TimeFormatType.LITERAL)))).action(context -> this.module.clickWarp(context, (PlayerWarp)warp)).build()).slots(new int[]{inventorySlot}).build());
            usedSlots.add(inventorySlot);
        });
        this.settings.getFeaturingSlotMap().forEach((id, slot) -> {
            Currency currency = slot.currency().orElse(null);
            if (currency == null) {
                return;
            }
            for (int index = 0; index < slot.inventorySlots().length; ++index) {
                int slotIndex = index;
                int inventorySlot = slot.inventorySlots()[index];
                if (usedSlots.contains(inventorySlot)) continue;
                items.add(MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(this.featuredIcon.copy().replace(builder -> builder.with(slot.placeholders()))).action(context -> this.module.openFeaturingDialog(context.getPlayer(), (FeaturedSlot)slot, slotIndex)).build()).slots(new int[]{inventorySlot}).build());
            }
        });
    }

    private void displayPopularWarps(@NotNull List<MenuItem> items) {
        List<PlayerWarp> popularWarps = this.module.getRepository().getPopularWarps();
        int[] popularSlots = this.settings.getPopularSlots();
        for (int index = 0; index < popularSlots.length; ++index) {
            int top = index + 1;
            int inventorySlot = popularSlots[index];
            if (index < popularWarps.size()) {
                PlayerWarp warp = popularWarps.get(index);
                items.add(MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(warp.getIcon().localized(ICON_POPULAR_WARP).replace(builder -> builder.with(warp.placeholders()).with("%value%", () -> String.valueOf(top)))).action(context -> this.module.clickWarp(context, warp)).build()).slots(new int[]{inventorySlot}).build());
                continue;
            }
            items.add(MenuItem.builder().defaultState(this.popularIcon.copy().replace(builder -> builder.with("%value%", () -> String.valueOf(top)))).slots(new int[]{inventorySlot}).build());
        }
    }

    private void displayCategories(@NotNull ViewerContext context, @NotNull List<MenuItem> items) {
        List<NormalCategory> categories = this.settings.getCategories().stream().sorted(Comparator.comparing(NormalCategory::id)).toList();
        this.categoryPopulator.populateTo(context, categories, items);
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        if (this.settings.isFeaturingEnabled()) {
            this.displayFeaturedWarps(inventory, items);
        }
        if (this.settings.isPopularEnabled()) {
            this.displayPopularWarps(items);
        }
        this.displayCategories(context, items);
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

