/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.menu;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.action.MenuItemAction;
import su.nightexpress.nightcore.ui.inventory.action.ObjectActionContext;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpRepository;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsModule;
import su.nightexpress.sunlight.module.playerwarps.category.WarpCategory;
import su.nightexpress.sunlight.module.playerwarps.core.PlayerWarpsSettings;
import su.nightexpress.sunlight.module.playerwarps.menu.PlayerWarpSortType;
import su.nightexpress.sunlight.module.playerwarps.menu.WarpsListData;

public class PlayerWarpsListMenu
extends AbstractObjectMenu<WarpsListData>
implements LangContainer {
    private static final IconLocale ICON_WARP_DEFAULT = LangEntry.iconBuilder((String)"PlayerWarps.UI.WarpsMenu.WarpDefault").rawName("%warp_name%").rawLore(new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Owner: " + TagWrappers.WHITE.wrap("%warp_owner_name%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Visits: " + TagWrappers.WHITE.wrap("%warp_visits%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Description:"), "%warp_description%", "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to teleport"))}).build();
    private static final IconLocale ICON_WARP_OWN = LangEntry.iconBuilder((String)"PlayerWarps.UI.WarpsMenu.WarpOwn").rawName("%warp_name%").rawLore(new String[]{TagWrappers.GREEN.wrap("\u2714 You own this warp."), "", TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Visits: " + TagWrappers.WHITE.wrap("%warp_visits%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Description:"), "%warp_description%", "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Left-Click to teleport")), TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Right-Click to edit"))}).build();
    private static final IconLocale ICON_WARP_MODERATE = LangEntry.iconBuilder((String)"PlayerWarps.UI.WarpsMenu.WarpModerate").rawName("%warp_name%").rawLore(new String[]{TagWrappers.GOLD.wrap("\u270e You can edit this warp."), "", TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Owner: " + TagWrappers.WHITE.wrap("%warp_owner_name%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Visits: " + TagWrappers.WHITE.wrap("%warp_visits%")), TagWrappers.DARK_GRAY.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Description:"), "%warp_description%", "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Left-Click to teleport")), TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Right-Click to edit"))}).build();
    private final SunLightPlugin plugin;
    private final PlayerWarpsModule module;
    private final PlayerWarpRepository repository;
    private final MenuItemAction backAction;
    private final MenuItemAction searchAction;
    private final MenuItemAction searchResetAction;
    private final MenuItemAction sortAction;
    private ItemPopulator<PlayerWarp> warpPopulator;

    public PlayerWarpsListMenu(@NonNull SunLightPlugin plugin, @NonNull PlayerWarpsModule module, @NonNull PlayerWarpsSettings settings, @NonNull PlayerWarpRepository repository) {
        super((MenuType)MenuType.GENERIC_9X6, "[Warps - %category%]", WarpsListData.class);
        this.plugin = plugin;
        this.module = module;
        this.repository = repository;
        this.backAction = this.createObjectAction(this::backToMainMenu);
        this.searchAction = this.createObjectAction(this::searchWarps);
        this.searchResetAction = this.createObjectAction(this::resetSearch);
        this.sortAction = this.createObjectAction(this::toggleSorting);
    }

    protected @NonNull String getRawTitle(@NonNull ViewerContext context) {
        return PlaceholderContext.builder().with("%category%", () -> ((WarpsListData)this.getObject(context)).category().name()).build().apply(super.getRawTitle(context));
    }

    public boolean show(@NonNull Player player, @NonNull WarpCategory category, @Nullable PlayerWarpSortType sortType, @Nullable String searchText) {
        if (sortType == null) {
            sortType = PlayerWarpSortType.DATE_CREATION;
        }
        return this.show(this.plugin, player, new WarpsListData(category, sortType, searchText));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(0, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(45, 54).toArray());
        this.addNextPageItem(Material.ARROW, new int[]{53});
        this.addPreviousPageItem(Material.ARROW, new int[]{45});
        this.addDefaultButton("back", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMPASS).setDisplayName(TagWrappers.WHITE.wrap("Back to Main Menu")).hideAllComponents()).action(this.backAction).build()).slots(new int[]{49}).build());
        this.addDefaultButton("search", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.SPRUCE_SIGN).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Search by Name")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Search warps by keywords"), TagWrappers.GRAY.wrap("in their names."), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to search"))})).hideAllComponents()).action(this.searchAction).build()).state(ItemState.builder((String)"with_input").icon(NightItem.fromType((Material)Material.DARK_OAK_SIGN).setDisplayName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Search by Name")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.WHITE.wrap("%input%")), "", TagWrappers.GRAY.wrap("Search warps by keywords in their names."), "", TagWrappers.YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to reset"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with("%input%", () -> ((WarpsListData)this.getObject(context)).searchText()))).condition(context -> ((WarpsListData)this.getObject(context)).searchText() != null).action(this.searchResetAction).build()).slots(new int[]{47}).build());
        this.addDefaultButton("sorting", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.HOPPER).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Sorting Mode")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.WHITE.wrap("%type%")), "", TagWrappers.GRAY.wrap("Toggle warps list order."), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to toggle"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with("%type%", () -> ((WarpsListData)this.getObject(context)).sortType().localized()))).action(this.sortAction).build()).slots(new int[]{51}).build());
    }

    protected void onLoad(@NonNull FileConfig config) {
        int[] warpSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Warps.Slots", (Object)IntStream.range(9, 45).toArray(), (String[])new String[0]).resolveWithDefaults(config);
        this.warpPopulator = ItemPopulator.builder(PlayerWarp.class).itemProvider((context, warp) -> {
            Player player = context.getPlayer();
            return warp.getIcon().hideAllComponents().localized(warp.isOwner(player) ? ICON_WARP_OWN : (warp.canEdit(player) ? ICON_WARP_MODERATE : ICON_WARP_DEFAULT)).replace(builder -> builder.with(warp.placeholders()));
        }).actionProvider(warp -> context -> this.module.clickWarp(context, (PlayerWarp)warp)).slots(warpSlots).build();
    }

    private void backToMainMenu(@NonNull ObjectActionContext<WarpsListData> context) {
        this.module.openWarpsMenu(context.getPlayer());
    }

    private void searchWarps(@NonNull ObjectActionContext<WarpsListData> context) {
        this.module.openSearchDialog(context.getPlayer(), (WarpsListData)this.getObject((ViewerContext)context));
    }

    private void resetSearch(@NonNull ObjectActionContext<WarpsListData> context) {
        WarpsListData data = (WarpsListData)this.getObject((ViewerContext)context);
        this.show(context.getPlayer(), data.category(), data.sortType(), null);
    }

    private void toggleSorting(@NonNull ObjectActionContext<WarpsListData> context) {
        WarpsListData data = (WarpsListData)this.getObject((ViewerContext)context);
        this.show(context.getPlayer(), data.category(), data.sortType().next(), data.searchText());
    }

    private boolean isGoodWarp(@NonNull PlayerWarp warp, @NonNull WarpsListData data) {
        if (!data.category().isWarpOfThis(warp)) {
            return false;
        }
        if (data.searchText() != null) {
            String lowName = LowerCase.INTERNAL.apply(NightMessage.stripTags((String)warp.getName()));
            return lowName.contains(data.searchText());
        }
        return true;
    }

    protected void onClick(@NonNull ViewerContext context, @NonNull InventoryClickEvent event) {
    }

    protected void onDrag(@NonNull ViewerContext context, @NonNull InventoryDragEvent event) {
    }

    protected void onClose(@NonNull ViewerContext context, @NonNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NonNull ViewerContext context, @NonNull InventoryView view, @NonNull Inventory inventory, @NonNull List<MenuItem> items) {
        WarpsListData data = (WarpsListData)this.getObject(context);
        PlayerWarpSortType sortType = data.sortType();
        List<PlayerWarp> warps = this.repository.stream().filter(warp -> this.isGoodWarp((PlayerWarp)warp, data)).sorted(sortType.getComparator()).toList();
        this.warpPopulator.populateTo(context, warps, items);
    }

    public void onReady(@NonNull ViewerContext context, @NonNull InventoryView view, @NonNull Inventory inventory) {
    }

    public void onRender(@NonNull ViewerContext context, @NonNull InventoryView view, @NonNull Inventory inventory) {
    }
}

