/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.menu;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.ui.inventory.action.MenuItemAction;
import su.nightexpress.nightcore.ui.inventory.action.ObjectActionContext;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsModule;
import su.nightexpress.sunlight.module.playerwarps.core.PlayerWarpsPerms;

public class PlayerWarpOptionsMenu
extends AbstractObjectMenu<PlayerWarp> {
    private final PlayerWarpsModule module;
    private final MenuItemAction backAction;
    private final MenuItemAction nameAction;
    private final MenuItemAction descriptionAction;
    private final MenuItemAction priceAction;
    private final MenuItemAction categoryAction;

    public PlayerWarpOptionsMenu(@NonNull PlayerWarpsModule module) {
        super((MenuType)MenuType.GENERIC_9X5, "[%s] Settings".formatted("%warp_name%"), PlayerWarp.class);
        this.module = module;
        this.backAction = this.createObjectAction(this::backToWarps);
        this.nameAction = this.createObjectAction(this::editName);
        this.descriptionAction = this.createObjectAction(this::editDescription);
        this.priceAction = this.createObjectAction(this::editPrice);
        this.categoryAction = this.createObjectAction(this::editCategory);
    }

    protected @NonNull String getRawTitle(@NonNull ViewerContext context) {
        return PlaceholderContext.builder().with(((PlayerWarp)this.getObject(context)).placeholders()).build().apply(super.getRawTitle(context));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(0, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(36, 45).toArray());
        this.addDefaultButton("back", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMPASS).setDisplayName(TagWrappers.WHITE.wrap("Go Back"))).action(this.backAction).build()).slots(new int[]{40}).build());
        this.addDefaultButton("name", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.NAME_TAG).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Name")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.WHITE.wrap("%warp_name%")), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with(((PlayerWarp)this.getObject(context)).placeholders()))).action(this.nameAction).build()).slots(new int[]{19}).build());
        this.addDefaultButton("description", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.WRITABLE_BOOK).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Description")).setLore(Lists.newList((Object[])new String[]{"%warp_description%", "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with(((PlayerWarp)this.getObject(context)).placeholders()))).action(this.descriptionAction).build()).slots(new int[]{21}).build());
        this.addDefaultButton("icon", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ITEM_FRAME).setDisplayName(TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("Icon")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Right click an item in your"), TagWrappers.GRAY.wrap("inventory to replace the icon.")})).hideAllComponents()).displayModifier((context, item) -> item.setMaterial(((PlayerWarp)this.getObject(context)).getIcon().getMaterial())).build()).slots(new int[]{23}).build());
        this.addDefaultButton("category", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ENCHANTED_BOOK).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Category")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.WHITE.wrap("%warp_category%")), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with(((PlayerWarp)this.getObject(context)).placeholders()))).action(this.categoryAction).build()).slots(new int[]{25}).build());
        this.addDefaultButton("price", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.EMERALD).setDisplayName(TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("Price")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.WHITE.wrap("%warp_price%")), "", TagWrappers.GREEN.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).condition(context -> EconomyBridge.hasCurrency() && context.getPlayer().hasPermission(PlayerWarpsPerms.OPTION_PRICE)).displayModifier((context, item) -> item.replace(builder -> builder.with(((PlayerWarp)this.getObject(context)).placeholders()))).action(this.priceAction).build()).slots(new int[]{4}).build());
    }

    protected void backToWarps(@NonNull ObjectActionContext<PlayerWarp> context) {
        this.module.openWarpsMenu(context.getPlayer());
    }

    private void editCategory(@NonNull ObjectActionContext<PlayerWarp> context) {
        this.module.openCategoryDialog(context.getPlayer(), (PlayerWarp)context.getObject(), () -> context.getViewer().refresh());
    }

    private void editName(@NonNull ObjectActionContext<PlayerWarp> context) {
        this.module.openNameDialog(context.getPlayer(), (PlayerWarp)context.getObject(), () -> context.getViewer().refresh());
    }

    private void editDescription(@NonNull ObjectActionContext<PlayerWarp> context) {
        this.module.openDescriptionDialog(context.getPlayer(), (PlayerWarp)context.getObject(), () -> context.getViewer().refresh());
    }

    private void editPrice(@NonNull ObjectActionContext<PlayerWarp> context) {
        this.module.openPriceDialog(context.getPlayer(), (PlayerWarp)context.getObject(), () -> context.getViewer().refresh());
    }

    protected void onLoad(@NonNull FileConfig config) {
    }

    protected void onClick(@NonNull ViewerContext context, @NonNull InventoryClickEvent event) {
        if (event.isRightClick() && event.getRawSlot() >= event.getInventory().getSize()) {
            ItemStack itemStack = event.getCurrentItem();
            if (itemStack == null || itemStack.getType().isAir()) {
                return;
            }
            PlayerWarp warp = (PlayerWarp)this.getObject(context);
            warp.setIcon(NightItem.fromItemStack((ItemStack)itemStack).hideAllComponents().ignoreNameAndLore());
            warp.markDirty();
            context.getViewer().refresh();
        }
    }

    protected void onDrag(@NonNull ViewerContext context, @NonNull InventoryDragEvent event) {
    }

    protected void onClose(@NonNull ViewerContext context, @NonNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NonNull ViewerContext context, @NonNull InventoryView view, @NonNull Inventory inventory, @NonNull List<MenuItem> items) {
    }

    public void onReady(@NonNull ViewerContext context, @NonNull InventoryView view, @NonNull Inventory inventory) {
    }

    public void onRender(@NonNull ViewerContext context, @NonNull InventoryView view, @NonNull Inventory inventory) {
    }
}

