/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.featuring;

import java.util.Optional;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.placeholder.PlaceholderResolvable;
import su.nightexpress.nightcore.util.placeholder.PlaceholderResolver;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsPlaceholders;

public record FeaturedSlot(@NonNull String id, @NonNull String currencyId, double price, long duration, int[] inventorySlots) implements Writeable,
PlaceholderResolvable
{
    public static @NonNull FeaturedSlot read(@NonNull FileConfig config, @NonNull String path) {
        String id = LowerCase.INTERNAL.apply(config.getString(path + ".Id", "null"));
        String currencyId = config.getString(path + ".Price.Currency", "vault");
        double price = config.getDouble(path + ".Price.Amount");
        long duration = config.getLong(path + ".Duration");
        int[] slotIndexes = config.getIntArray(path + ".Slots");
        return new FeaturedSlot(id, currencyId, price, duration, slotIndexes);
    }

    public void write(@NonNull FileConfig config, @NonNull String path) {
        config.set(path + ".Id", (Object)this.id);
        config.set(path + ".Price.Currency", (Object)this.currencyId);
        config.set(path + ".Price.Amount", (Object)this.price);
        config.set(path + ".Duration", (Object)this.duration);
        config.setArray(path + ".Slots", this.inventorySlots);
    }

    public @NonNull PlaceholderResolver placeholders() {
        return PlayerWarpsPlaceholders.FEATURED_SLOT.resolver((Object)this);
    }

    public @NonNull Optional<Currency> currency() {
        return EconomyBridge.currency((String)this.currencyId);
    }

    public void pay(@NonNull Player player) {
        this.currency().ifPresent(currency -> currency.take(player, this.price));
    }

    public boolean canAfford(@NonNull Player player) {
        return this.currency().map(currency -> currency.getBalance(player)).orElse(0.0) >= this.price;
    }

    public boolean containsSlot(int slotIndex) {
        return Lists.contains((int[])this.inventorySlots, (int)slotIndex);
    }

    public long createEndTimestamp() {
        return TimeUtil.createFutureTimestamp((double)this.duration);
    }
}

