/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.dialog.impl;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsModule;
import su.nightexpress.sunlight.module.playerwarps.menu.WarpsListData;

public class PlayerWarpsSearchDialog
extends Dialog<WarpsListData> {
    private static final TextLocale TITLE = LangEntry.builder((String)"PlayerWarps.Dialog.WarpSearch.Title").text(PlayerWarpsSearchDialog.title("Player Warps", "Search"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"PlayerWarps.Dialog.WarpSearch.Body").dialogElement(400, new String[]{"Enter text to search."});
    private static final TextLocale INPUT_TEXT = LangEntry.builder((String)"PlayerWarps.Dialog.WarpSearch.Input.Text").text("Search for");
    private static final String JSON_TEXT = "text";
    protected final PlayerWarpsModule module;

    public PlayerWarpsSearchDialog(@NonNull PlayerWarpsModule module) {
        this.module = module;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull WarpsListData data) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_TEXT, (TextLocale)INPUT_TEXT).maxLength(40).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            String text = nbtHolder.getText(JSON_TEXT).orElse(null);
            this.module.openWarpsList(viewer.getPlayer(), data.category(), data.sortType(), text);
        }).build();
    }
}

