/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.dialog.impl;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;

public class PlayerWarpPriceDialog
extends Dialog<PlayerWarp> {
    private static final TextLocale TITLE = LangEntry.builder((String)"PlayerWarps.Dialog.WarpPrice.Title").text(PlayerWarpPriceDialog.title("Warp", "Price"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"PlayerWarps.Dialog.WarpPrice.Body").dialogElement(400, new String[]{"Please enter a price for your warp."});
    private static final TextLocale INPUT_PRICE = LangEntry.builder((String)"PlayerWarps.Dialog.WarpPrice.Input.Price").text((String)TagWrappers.SPRITE_ITEM.apply(Material.EMERALD) + " Price");
    private static final String JSON_PRICE = "price";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull PlayerWarp warp) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_PRICE, (TextLocale)INPUT_PRICE).maxLength(12).initial(String.valueOf(warp.getPrice())).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            double cost = nbtHolder.getDouble(JSON_PRICE).orElse(warp.getPrice());
            warp.setPrice(cost);
            warp.markDirty();
            viewer.callback();
        }).build();
    }
}

