/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.dialog.impl;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.core.PlayerWarpsSettings;

public class PlayerWarpNameDialog
extends Dialog<PlayerWarp> {
    private static final TextLocale TITLE = LangEntry.builder((String)"PlayerWarps.Dialog.WarpName.Title").text(PlayerWarpNameDialog.title("Warp", "Name"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"PlayerWarps.Dialog.WarpName.Body").dialogElement(400, new String[]{"Please enter a name for your warp.", "", "You can click " + ((SimpleTagWrapper)TagWrappers.OPEN_URL.with("https://nightexpressdev.com/nightcore/configuration/text-formation/")).wrap(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("HERE")) + " to see all available formatting tags and color codes."});
    private static final TextLocale INPUT_NAME = LangEntry.builder((String)"PlayerWarps.Dialog.WarpName.Input.Name").text((String)TagWrappers.SPRITE_ITEM.apply(Material.NAME_TAG) + " Name");
    private static final String JSON_NAME = "name";
    private final PlayerWarpsSettings settings;

    public PlayerWarpNameDialog(@NonNull PlayerWarpsSettings settings) {
        this.settings = settings;
    }

    @Override
    public @NonNull WrappedDialog create(@NonNull Player player, @NonNull PlayerWarp warp) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_NAME, (TextLocale)INPUT_NAME).maxLength(this.settings.getWarpNameCharacterLimit()).initial(warp.getName()).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            String name = nbtHolder.getText(JSON_NAME, warp.getName());
            warp.setName(name);
            warp.markDirty();
            viewer.callback();
        }).build();
    }
}

