/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.dialog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogAfterAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsModule;
import su.nightexpress.sunlight.module.playerwarps.featuring.FeaturedSlot;

public class PlayerWarpFeaturingDialog
extends Dialog<Data> {
    private static final TextLocale TITLE = LangEntry.builder((String)"PlayerWarps.Dialog.Featuring.Title").text(PlayerWarpFeaturingDialog.title("Warp", "Featuring"));
    private static final DialogElementLocale BODY_SELECTION = LangEntry.builder((String)"PlayerWarps.Dialog.Featuring.Body.Selection").dialogElement(400, new String[]{"Select a warp to feature for promotion.", "", "It will remain featured for " + TagWrappers.YELLOW.wrap("%slot_duration%") + ". Cost: " + TagWrappers.GREEN.wrap("%slot_price%") + "."});
    private static final DialogElementLocale BODY_CONFIRMATION = LangEntry.builder((String)"PlayerWarps.Dialog.Featuring.Body.Confirmation").dialogElement(400, new String[]{"Please confirm featuring for the " + TagWrappers.YELLOW.and((TagWrapper)TagWrappers.UNDERLINED).wrap("%warp_name%") + " warp.", "", "It will remain featured for " + TagWrappers.YELLOW.wrap("%slot_duration%") + ". Cost: " + TagWrappers.GREEN.wrap("%slot_price%") + "."});
    private static final ButtonLocale BUTTON_WARP = LangEntry.builder((String)"PlayerWarps.Dialog.Featuring.Button.Warp").button("%warp_name%", "%warp_description%");
    private static final String ACTION_WARP = "warp";
    private static final String JSON_ID = "id";
    private final PlayerWarpsModule module;
    private final Map<UUID, String> idCache;

    public PlayerWarpFeaturingDialog(@NonNull PlayerWarpsModule module) {
        this.module = module;
        this.idCache = new HashMap<UUID, String>();
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Data data) {
        boolean selected;
        ArrayList<WrappedActionButton> buttons = new ArrayList<WrappedActionButton>();
        PlaceholderContext.Builder bodyPlaceholders = PlaceholderContext.builder().with(data.slot.placeholders());
        String selectedId = this.idCache.get(player.getUniqueId());
        PlayerWarp selectedWarp = selectedId == null ? null : this.module.getRepository().getById(selectedId);
        boolean bl = selected = selectedWarp != null;
        if (!selected) {
            this.module.getRepository().getByOwner(player.getUniqueId()).stream().filter(Predicate.not(PlayerWarp::isFeatured)).forEach(warp -> {
                PlaceholderContext placeholderContext = PlaceholderContext.builder().with(warp.placeholders()).build();
                ButtonLocale locale = BUTTON_WARP.replace(arg_0 -> ((PlaceholderContext)placeholderContext).apply(arg_0));
                buttons.add(DialogButtons.action((ButtonLocale)locale).action((WrappedDialogAction)DialogActions.customClick((String)ACTION_WARP, (NightNbtHolder)NightNbtHolder.builder().put(JSON_ID, warp.getId()).build())).build());
            });
        } else {
            bodyPlaceholders.with(selectedWarp.placeholders());
            buttons.add(DialogButtons.ok());
        }
        WrappedDialogBody[] wrappedDialogBodyArray = new WrappedDialogBody[1];
        wrappedDialogBodyArray[0] = DialogBodies.plainMessage((DialogElementLocale)(selected ? BODY_CONFIRMATION : BODY_SELECTION).replace(arg_0 -> ((PlaceholderContext)bodyPlaceholders.build()).apply(arg_0)));
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(wrappedDialogBodyArray).afterAction(WrappedDialogAfterAction.NONE).build()).type((WrappedDialogType)DialogTypes.multiAction(buttons).exitAction(DialogButtons.back()).build()).handleResponse(ACTION_WARP, (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            String id = nbtHolder.getText(JSON_ID).orElse(null);
            if (id == null) {
                return;
            }
            this.idCache.put(viewer.getPlayer().getUniqueId(), id);
            this.show(viewer.getPlayer(), data, viewer.getCallback());
        }).handleResponse("back", (viewer, identifier, nbtHolder) -> {
            this.idCache.remove(viewer.getPlayer().getUniqueId());
            viewer.closeFully();
        }).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            String id = this.idCache.remove(viewer.getPlayer().getUniqueId());
            if (id == null) {
                return;
            }
            viewer.close();
            this.module.purchaseFeaturedSlot(viewer.getPlayer(), data.slot, data.slotIndex, id);
        }).build();
    }

    public record Data(@NonNull FeaturedSlot slot, int slotIndex) {
    }
}

