/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.dialog.impl;

import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsModule;
import su.nightexpress.sunlight.module.playerwarps.category.NormalCategory;

public class PlayerWarpCategoryDialog
extends Dialog<PlayerWarp> {
    private static final TextLocale TITLE = LangEntry.builder((String)"PlayerWarps.Dialog.WarpCategory.Title").text(PlayerWarpCategoryDialog.title("Warp", "Category"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"PlayerWarps.Dialog.WarpCategory.Body.Selection").dialogElement(400, new String[]{"Please Select a category for your warp."});
    private static final ButtonLocale BUTTON_NORMAL = LangEntry.builder((String)"PlayerWarps.Dialog.WarpCategory.Button.CategoryNormal").button("%category_name%", "%category_description%");
    private static final ButtonLocale BUTTON_SELECTED = LangEntry.builder((String)"PlayerWarps.Dialog.WarpCategory.Button.CategorySelected").button(TagWrappers.GREEN.wrap("\u2714 " + TagWrappers.UNDERLINED.wrap("%category_name%")), "%category_description%");
    private static final String ACTION_CATEGORY = "category";
    private static final String JSON_ID = "id";
    private final PlayerWarpsModule module;

    public PlayerWarpCategoryDialog(@NonNull PlayerWarpsModule module) {
        this.module = module;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull PlayerWarp warp) {
        ArrayList buttons = new ArrayList();
        this.module.getSettings().getCategories().forEach(category -> {
            PlaceholderContext placeholderContext = PlaceholderContext.builder().with(category.placeholders()).build();
            ButtonLocale locale = warp.isCategory((NormalCategory)category) ? BUTTON_SELECTED : BUTTON_NORMAL;
            buttons.add(DialogButtons.action((ButtonLocale)locale.replace(arg_0 -> ((PlaceholderContext)placeholderContext).apply(arg_0))).action((WrappedDialogAction)DialogActions.customClick((String)ACTION_CATEGORY, (NightNbtHolder)NightNbtHolder.builder().put(JSON_ID, category.id()).build())).build());
        });
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).build()).type((WrappedDialogType)DialogTypes.multiAction(buttons).exitAction(DialogButtons.back()).build()).handleResponse(ACTION_CATEGORY, (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            String id = nbtHolder.getText(JSON_ID).orElse(null);
            if (id == null) {
                return;
            }
            NormalCategory category = this.module.getSettings().getCategory(id);
            if (category == null) {
                return;
            }
            warp.setCategory(category);
            warp.markDirty();
            viewer.callback();
        }).build();
    }
}

