/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps.command;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarpsModule;
import su.nightexpress.sunlight.module.playerwarps.core.PlayerWarpsLang;
import su.nightexpress.sunlight.module.playerwarps.core.PlayerWarpsPerms;
import su.nightexpress.sunlight.user.UserManager;

public class PlayerWarpsCommands
extends AbstractCommandProvider {
    private static final String ARGUMENT_WARP = "warp";
    private static final String COMMAND_CREATE = "create";
    private static final String COMMAND_UPDATE = "update";
    private static final String COMMAND_DELETE = "delete";
    private static final String COMMAND_MENU = "menu";
    private static final String COMMAND_JUMP = "teleport";
    private final PlayerWarpsModule module;
    private final UserManager userManager;

    public PlayerWarpsCommands(@NonNull SunLightPlugin plugin, @NonNull PlayerWarpsModule module, @NonNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    private @NonNull ArgumentNodeBuilder<PlayerWarp> warpArgument(@Nullable BiFunction<Player, PlayerWarp, Boolean> suggestions) {
        return this.warpArgument(null, suggestions);
    }

    private @NonNull ArgumentNodeBuilder<PlayerWarp> warpArgument(@Nullable Predicate<PlayerWarp> predicate, @Nullable BiFunction<Player, PlayerWarp, Boolean> suggestions) {
        return Commands.argument((String)ARGUMENT_WARP, (context, str) -> Optional.ofNullable(this.module.getRepository().getById(str)).filter(warp -> predicate == null || predicate.test((PlayerWarp)warp)).orElseThrow(() -> CommandSyntaxException.custom((MessageLocale)PlayerWarpsLang.COMMAND_SYNTAX_INVALID_WARP))).localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME).suggestions((reader, context) -> {
            Player player = context.getPlayer();
            return this.module.getRepository().stream().filter(warp -> player == null || suggestions == null || (Boolean)suggestions.apply(player, (PlayerWarp)warp) != false).map(PlayerWarp::getId).toList();
        });
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_CREATE, false, new String[]{"setwarp"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(PlayerWarpsLang.COMMAND_WARPS_CREATE_DESC)).permission(PlayerWarpsPerms.COMMAND_WARPS_CREATE)).withArguments(new ArgumentNodeBuilder[]{Arguments.string((String)"name").localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME)}).executes(this::createWarp));
        this.registerLiteral(COMMAND_UPDATE, false, new String[]{"updatewarp"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(PlayerWarpsLang.COMMAND_WARPS_UPDATE_DESC)).permission(PlayerWarpsPerms.COMMAND_WARPS_UPDATE)).withArguments(new ArgumentNodeBuilder[]{this.warpArgument((player, warp) -> warp.canEdit((Player)player))}).executes(this::updateWarp));
        this.registerLiteral(COMMAND_DELETE, false, new String[]{"delwarp"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(PlayerWarpsLang.COMMAND_WARPS_DELETE_DESC)).permission(PlayerWarpsPerms.COMMAND_WARPS_DELETE)).withArguments(new ArgumentNodeBuilder[]{this.warpArgument((player, warp) -> warp.canEdit((Player)player))}).executes(this::deleteWarp));
        this.registerLiteral(COMMAND_JUMP, false, new String[]{ARGUMENT_WARP}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(PlayerWarpsLang.COMMAND_WARPS_JUMP_DESC)).permission(PlayerWarpsPerms.COMMAND_WARPS_JUMP)).withArguments(new ArgumentNodeBuilder[]{this.warpArgument(PlayerWarp::isActive, (player, warp) -> warp.canUse((Player)player)), (ArgumentNodeBuilder)Arguments.playerName((String)"player").optional().permission(PlayerWarpsPerms.COMMAND_WARPS_JUMP_OTHERS)}).withFlags(new String[]{"f"}).executes(this::moveToWarp));
        this.registerLiteral(COMMAND_MENU, true, new String[]{"pwarps"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(PlayerWarpsLang.COMMAND_WARPS_LIST_DESC)).permission(PlayerWarpsPerms.COMMAND_WARPS_LIST)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PlayerWarpsPerms.COMMAND_WARPS_LIST_OTHERS)).optional()}).executes(this::openWarps));
        this.registerRoot("PlayerWarps", true, new String[]{"pwarp", "playerwarps"}, (Map<String, String> map) -> {
            map.put(COMMAND_CREATE, COMMAND_CREATE);
            map.put(COMMAND_UPDATE, COMMAND_UPDATE);
            map.put(COMMAND_DELETE, COMMAND_DELETE);
            map.put(COMMAND_MENU, COMMAND_MENU);
            map.put(COMMAND_JUMP, "jump");
        }, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(PlayerWarpsLang.COMMAND_WARPS_ROOT_DESC)).permission(PlayerWarpsPerms.COMMAND_WARPS_ROOT));
    }

    private boolean createWarp(@NonNull CommandContext context, @NonNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        return this.module.create(player, arguments.getString("name"), false);
    }

    private boolean updateWarp(@NonNull CommandContext context, @NonNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        PlayerWarp warp = (PlayerWarp)arguments.get(ARGUMENT_WARP, PlayerWarp.class);
        return this.module.updateWarp(player, warp, false);
    }

    private boolean deleteWarp(@NonNull CommandContext context, @NonNull ParsedArguments arguments) {
        PlayerWarp warp = (PlayerWarp)arguments.get(ARGUMENT_WARP, PlayerWarp.class);
        return this.module.removeWarp(context.getSender(), warp, false);
    }

    private boolean openWarps(@NonNull CommandContext context, @NonNull ParsedArguments arguments) {
        return this.runForOnlinePlayerOrSender(context, arguments, this.module, target -> {
            this.module.openWarpsMenu((Player)target);
            if (context.getSender() != target) {
                this.module.sendPrefixed(PlayerWarpsLang.WARP_LIST_OPEN_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            return true;
        });
    }

    private boolean moveToWarp(@NonNull CommandContext context, @NonNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            PlayerWarp warp = (PlayerWarp)arguments.get(ARGUMENT_WARP, PlayerWarp.class);
            boolean force = context.hasFlag("f");
            if (context.getSender() != target) {
                this.module.sendPrefixed(PlayerWarpsLang.WARP_JUMP_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with(warp.placeholders()));
            }
            this.module.teleportToWarp(warp, (Player)target, force);
        });
    }
}

