/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bukkit.World;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.language.LangAssets;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.placeholder.TypedPlaceholder;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.category.NormalCategory;
import su.nightexpress.sunlight.module.playerwarps.category.WarpCategory;
import su.nightexpress.sunlight.module.playerwarps.featuring.FeaturedSlot;

public class PlayerWarpsPlaceholders {
    public static final String WARP_ID = "%warp_id%";
    public static final String WARP_NAME = "%warp_name%";
    public static final String WARP_DESCRIPTION = "%warp_description%";
    public static final String WARP_PRICE = "%warp_price%";
    public static final String WARP_WORLD = "%warp_location_world%";
    public static final String WARP_LOCATION_X = "%warp_location_x%";
    public static final String WARP_LOCATION_Y = "%warp_location_y%";
    public static final String WARP_LOCATION_Z = "%warp_location_z%";
    public static final String WARP_CATEGORY = "%warp_category%";
    public static final String WARP_VISITS = "%warp_visits%";
    public static final String WARP_OWNER_NAME = "%warp_owner_name%";
    public static final String SLOT_PRICE = "%slot_price%";
    public static final String SLOT_DURATION = "%slot_duration%";
    public static final String CATEGORY_NAME = "%category_name%";
    public static final String CATEGORY_DESCRIPTION = "%category_description%";
    public static final TypedPlaceholder<PlayerWarp> PLAYER_WARP = TypedPlaceholder.builder(PlayerWarp.class).with("%warp_id%", PlayerWarp::getId).with("%warp_name%", PlayerWarp::getName).with("%warp_description%", warp -> String.join((CharSequence)"\n", warp.getDescription())).with("%warp_price%", warp -> warp.hasPrice() ? NumberUtil.format((double)warp.getPrice()) : Lang.OTHER_FREE.text()).with("%warp_location_x%", warp -> NumberUtil.format((double)warp.getBlockPos().getX())).with("%warp_location_y%", warp -> NumberUtil.format((double)warp.getBlockPos().getY())).with("%warp_location_z%", warp -> NumberUtil.format((double)warp.getBlockPos().getZ())).with("%warp_location_world%", warp -> warp.isActive() ? LangAssets.get((World)warp.getWorld()) : warp.getWorldName()).with("%warp_category%", warp -> Optional.ofNullable(warp.getCategory()).map(WarpCategory::name).orElse(warp.getCategoryId())).with("%warp_visits%", warp -> String.valueOf(warp.getTotalVisits())).with("%warp_owner_name%", warp -> warp.getOwner().name()).build();
    public static final TypedPlaceholder<FeaturedSlot> FEATURED_SLOT = TypedPlaceholder.builder(FeaturedSlot.class).with("%slot_price%", slot -> EconomyBridge.getCurrencyOrDummy((String)slot.currencyId()).format(slot.price())).with("%slot_duration%", slot -> TimeFormats.formatAmount((long)TimeUnit.SECONDS.toMillis(slot.duration()), (TimeFormatType)TimeFormatType.LITERAL)).build();
    public static final TypedPlaceholder<NormalCategory> CATEGORY = TypedPlaceholder.builder(NormalCategory.class).with("%category_name%", NormalCategory::name).with("%category_description%", category -> String.join((CharSequence)"\n", category.description())).build();
}

