/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.playerwarps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.sunlight.module.playerwarps.PlayerWarp;
import su.nightexpress.sunlight.module.playerwarps.category.WarpCategory;
import su.nightexpress.sunlight.module.playerwarps.featuring.FeaturedSlot;

public class PlayerWarpRepository {
    private final Map<String, PlayerWarp> byIdMap = new HashMap<String, PlayerWarp>();
    private final Map<UUID, Set<PlayerWarp>> byOwnerMap = new HashMap<UUID, Set<PlayerWarp>>();
    private final Set<PlayerWarp> featuredWarps = new HashSet<PlayerWarp>();
    private final List<PlayerWarp> popularWarps = new ArrayList<PlayerWarp>();

    public void add(@NonNull PlayerWarp warp) {
        this.byIdMap.put(warp.getId(), warp);
        this.byOwnerMap.computeIfAbsent(warp.getOwnerId(), k -> new HashSet()).add(warp);
    }

    public void remove(@NonNull PlayerWarp warp) {
        this.byIdMap.remove(warp.getId());
        this.byOwnerMap.getOrDefault(warp.getOwnerId(), Collections.emptySet()).remove(warp);
        this.featuredWarps.remove(warp);
        this.popularWarps.remove(warp);
    }

    public void clear() {
        this.byIdMap.clear();
        this.byOwnerMap.clear();
    }

    public int size() {
        return this.byIdMap.size();
    }

    public boolean hasWarp(@NonNull String id) {
        return this.byIdMap.containsKey(LowerCase.INTERNAL.apply(id));
    }

    public boolean isFeatured(@NonNull FeaturedSlot slot, int slotIndex) {
        return this.getFeaturedWarps().stream().anyMatch(warp -> warp.isFeatured(slot, slotIndex));
    }

    public void updateFeaturedWarps() {
        this.featuredWarps.clear();
        this.stream().filter(PlayerWarp::isFeatured).forEach(this.featuredWarps::add);
    }

    public void updatePopularWarps(int limit) {
        this.popularWarps.clear();
        this.stream().sorted(Comparator.comparingLong(PlayerWarp::getTotalVisits).reversed()).limit(limit).forEach(this.popularWarps::add);
    }

    public int countWarps(@NonNull WarpCategory category) {
        return this.getByCategory(category).size();
    }

    public int countOwnedWarps(@NonNull UUID playerId) {
        return this.getByOwner(playerId).size();
    }

    public @NonNull Stream<PlayerWarp> stream() {
        return this.byIdMap.values().stream();
    }

    public @NonNull Map<String, PlayerWarp> getByIdMap() {
        return this.byIdMap;
    }

    public @NonNull Map<UUID, Set<PlayerWarp>> getByOwnerMap() {
        return this.byOwnerMap;
    }

    public @Nullable PlayerWarp getById(@NonNull String id) {
        return this.byIdMap.get(LowerCase.INTERNAL.apply(id));
    }

    public @NonNull Set<PlayerWarp> getByOwner(@NonNull UUID playerId) {
        return Set.copyOf(this.byOwnerMap.getOrDefault(playerId, Collections.emptySet()));
    }

    public @NonNull Set<PlayerWarp> getAll() {
        return Set.copyOf(this.byIdMap.values());
    }

    public @NonNull Set<PlayerWarp> getByCategory(@NonNull WarpCategory category) {
        return this.stream().filter(category::isWarpOfThis).collect(Collectors.toSet());
    }

    public @NonNull Set<PlayerWarp> getFeaturedWarps() {
        return this.featuredWarps;
    }

    public @NonNull List<PlayerWarp> getPopularWarps() {
        return this.popularWarps;
    }
}

