/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.nerfphantoms.listener;

import java.util.Set;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Phantom;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.nerfphantoms.PhantomsModule;
import su.nightexpress.sunlight.module.nerfphantoms.config.PhantomsConfig;

public class PhantomsListener
extends AbstractListener<SunLightPlugin> {
    public PhantomsListener(@NotNull SunLightPlugin plugin, @NotNull PhantomsModule module) {
        super((NightCorePlugin)plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPhantomSpawn(CreatureSpawnEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Phantom)) {
            return;
        }
        Phantom phantom = (Phantom)livingEntity;
        if (((Boolean)PhantomsConfig.DISABLE_SPAWN_ENABLED.get()).booleanValue() && ((Set)PhantomsConfig.DISABLE_SPAWN_REASONS.get()).contains(event.getSpawnReason())) {
            event.setCancelled(true);
            return;
        }
        if (((Boolean)PhantomsConfig.DAMAGE_MODIFIER_ENABLED.get()).booleanValue()) {
            this.modifyAttribute(phantom, Attribute.ATTACK_DAMAGE, (Double)PhantomsConfig.DAMAGE_MODIFIER_VALUE.get());
        }
        if (((Boolean)PhantomsConfig.HEALTH_MODIFIER_ENABLED.get()).booleanValue()) {
            this.modifyAttribute(phantom, Attribute.MAX_HEALTH, (Double)PhantomsConfig.HEALTH_MODIFIER_VALUE.get());
        }
    }

    private void modifyAttribute(@NotNull Phantom phantom, @NotNull Attribute attribute, double value) {
        AttributeInstance instance = phantom.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        if (attribute == Attribute.ATTACK_DAMAGE) {
            value = EntityUtil.getAttribute((LivingEntity)phantom, (Attribute)attribute) * value;
        }
        instance.setBaseValue(value);
        if (attribute == Attribute.MAX_HEALTH) {
            phantom.setHealth(value);
        }
    }
}

