/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.nametags.handler;

import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.nametags.NameTagFormat;

public abstract class NametagHandler
extends SimpleManager<SunLightPlugin> {
    public NametagHandler(@NotNull SunLightPlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    public void sendTeamPacket(@NotNull Player playerOfTeam, @NotNull NameTagFormat tag, @NotNull PlaceholderContext placeholderContext) {
        String uuid = SLUtils.createIdentifier(playerOfTeam);
        Object teamId = "sl_" + uuid;
        if (((String)teamId).length() > 16) {
            teamId = ((String)teamId).substring(0, 16);
        }
        String teamPrefix = placeholderContext.apply(tag.getPrefix());
        String teamSuffix = placeholderContext.apply(tag.getSuffix());
        String teamColorRaw = placeholderContext.apply(tag.getColor());
        Collection receivers = Bukkit.getServer().getOnlinePlayers();
        for (TeamMode mode : TeamMode.values()) {
            this.sendPacket(mode, (String)teamId, teamPrefix, teamSuffix, teamColorRaw, playerOfTeam, receivers);
        }
    }

    protected abstract void sendPacket(@NotNull TeamMode var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, @NotNull String var5, @NotNull Player var6, @NotNull Collection<? extends Player> var7);

    public static enum TeamMode {
        REMOVE(1),
        CREATE(0);

        public final int index;

        private TeamMode(int index) {
            this.index = index;
        }
    }
}

