/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.integration.item.impl.AdaptedItemStack;
import su.nightexpress.nightcore.util.Numbers;

public class KitContent
implements Writeable {
    private final Map<Integer, AdaptedItem> itemBySlotMap;

    public KitContent(@NotNull Map<Integer, AdaptedItem> itemBySlotMap) {
        this.itemBySlotMap = itemBySlotMap;
    }

    @NotNull
    public static KitContent empty() {
        return new KitContent(new HashMap<Integer, AdaptedItem>());
    }

    @NotNull
    public static KitContent copyOf(@NotNull KitContent other) {
        return new KitContent(new HashMap<Integer, AdaptedItem>(other.getItemBySlotMap()));
    }

    @NotNull
    public static KitContent read(@NotNull FileConfig config, @NotNull String path) {
        HashMap<Integer, AdaptedItem> itemBySlotMap = new HashMap<Integer, AdaptedItem>();
        config.getSection(path).forEach(sId -> {
            int slot = Numbers.parseInteger((String)sId).orElse(-1);
            if (slot < 0) {
                return;
            }
            AdaptedItemStack adaptedItem = AdaptedItemStack.read((FileConfig)config, (String)(path + "." + sId));
            if (adaptedItem == null) {
                return;
            }
            itemBySlotMap.put(slot, (AdaptedItem)adaptedItem);
        });
        return new KitContent(itemBySlotMap);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.remove(path);
        this.itemBySlotMap.forEach((slot, adaptedItem) -> config.set(path + "." + slot, adaptedItem));
    }

    @NotNull
    public List<ItemStack> give(@NotNull BiConsumer<Integer, ItemStack> consumer) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        this.itemBySlotMap.forEach((slot, adaptedItem) -> adaptedItem.itemStack().ifPresent(itemStack -> consumer.accept((Integer)slot, (ItemStack)itemStack)));
        return leftovers;
    }

    @NotNull
    public Map<Integer, AdaptedItem> getItemBySlotMap() {
        return this.itemBySlotMap;
    }
}

