/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.menu;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.EnumLocale;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.kits.KitsModule;
import su.nightexpress.sunlight.module.kits.config.KitsPerms;
import su.nightexpress.sunlight.module.kits.data.KitData;
import su.nightexpress.sunlight.module.kits.model.Kit;

public class KitsMenu
extends AbstractMenu
implements LangContainer {
    private static final EnumLocale<KitStatus> KIT_STATUS_LOCALE = LangEntry.builder((String)"Kits.UI.KitBrowser.KitStatus").enumeration(KitStatus.class, KitStatus::getDefaultText);
    private static final IconLocale KIT_ICON = LangEntry.iconBuilder((String)"Kits.UI.KitBrowser.KitIcon").accentColor((TagWrapper)TagWrappers.WHITE).rawName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Kit: ") + TagWrappers.WHITE.wrap("%kit_name%")).rawLore(new String[]{"%kit_description%"}).rawLore(new String[]{"%empty-if-above%"}).appendCurrent("Cost", "%kit_cost_money%").appendCurrent("Cooldown", "%kit_cooldown%").br().rawLore(new String[]{"%status%"}).build();
    private final KitsModule module;
    private ItemPopulator<Kit> kitPopulator;

    public KitsMenu(@NotNull SunLightPlugin plugin, @NotNull KitsModule module) {
        super((MenuType)MenuType.GENERIC_9X4, "Kits");
        this.module = module;
        plugin.injectLang(this);
        this.load(plugin, FileConfig.load((String)module.getLocalUIPath(), (String)"kit_list.yml"));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.GRAY_STAINED_GLASS_PANE, IntStream.range(0, 27).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(27, 36).toArray());
        this.addNextPageItem(Material.ARROW, new int[]{35});
        this.addPreviousPageItem(Material.ARROW, new int[]{27});
    }

    protected void onLoad(@NotNull FileConfig config) {
        int[] kitSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Kit.Slots", (Object)new int[]{10, 11, 12, 13, 14, 15, 16}, (String[])new String[0]).resolveWithDefaults(config);
        this.kitPopulator = ItemPopulator.builder(Kit.class).actionProvider(kit -> context -> {
            Player player = context.getPlayer();
            if (context.getEvent().isRightClick()) {
                this.module.previewKit(player, (Kit)kit);
                return;
            }
            KitStatus status = this.getKitStatus(player, (Kit)kit);
            if (status != KitStatus.AVAILABLE) {
                return;
            }
            this.module.giveKit((Kit)kit, player, false, false);
            context.getViewer().refresh();
        }).itemProvider((context, kit) -> kit.definition().getIcon().hideAllComponents().localized(KIT_ICON).replace(builder -> builder.with(kit.placeholders()).with("%status%", () -> KIT_STATUS_LOCALE.getLocalized((Enum)this.getKitStatus(context.getPlayer(), (Kit)kit))))).slots(kitSlots).build();
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        Collection<Kit> availableKits = this.module.getSettings().isHideNoPermKits() ? this.module.getKits(context.getPlayer()) : this.module.getKits();
        List<Kit> kits = availableKits.stream().sorted(Comparator.comparingInt(kit -> kit.definition().getPriority())).toList();
        this.kitPopulator.populateTo(context, kits, items);
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    @NotNull
    private KitStatus getKitStatus(@NotNull Player player, @NotNull Kit kit) {
        KitData data;
        if (!kit.hasPermission(player)) {
            return KitStatus.NO_PERMISSION;
        }
        if (kit.hasCost() && !player.hasPermission(KitsPerms.BYPASS_COST)) {
            double cost = kit.definition().getCost();
            double balance = EconomyBridge.getEconomyBalance((Player)player);
            if (balance < cost) {
                return KitStatus.TOO_EXPENSIVE;
            }
        }
        if (kit.hasCooldown() && !player.hasPermission(KitsPerms.BYPASS_COOLDOWN) && (data = this.module.getKitData(player.getUniqueId(), kit.getId())) != null && !data.isCooldownExpired()) {
            return KitStatus.ON_COOLDOWN;
        }
        return KitStatus.AVAILABLE;
    }

    static enum KitStatus {
        NO_PERMISSION(TagWrappers.RED.wrap("\u2718 " + TagWrappers.UNDERLINED.wrap("You aren't allowed to use this kit."))),
        TOO_EXPENSIVE(TagWrappers.RED.wrap("\u2718 " + TagWrappers.UNDERLINED.wrap("You can't afford this kit."))),
        ON_COOLDOWN(TagWrappers.ORANGE.wrap("\u231b " + TagWrappers.UNDERLINED.wrap("The kit is on cooldown."))),
        AVAILABLE(TagWrappers.GREEN.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to get this kit!")));

        private final String defaultText;

        private KitStatus(String defaultText) {
            this.defaultText = defaultText;
        }

        @NotNull
        public String getDefaultText() {
            return this.defaultText;
        }
    }
}

