/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.listener;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.kits.KitsModule;
import su.nightexpress.sunlight.module.kits.KitsUtils;

public class KitBindListener
extends AbstractListener<SunLightPlugin> {
    public KitBindListener(@NotNull SunLightPlugin plugin, @NotNull KitsModule module) {
        super((NightCorePlugin)plugin);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBindItemPickup(EntityPickupItemEvent event) {
        LivingEntity entity;
        ItemStack item = event.getItem().getItemStack();
        if (!KitsUtils.isItemOwner(item, (Entity)(entity = event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBindItemClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType().isAir()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!KitsUtils.isItemOwner(item, (Entity)player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBindItemDispense(BlockDispenseArmorEvent event) {
        LivingEntity entity;
        ItemStack item = event.getItem();
        if (!KitsUtils.isItemOwner(item, (Entity)(entity = event.getTargetEntity()))) {
            event.setCancelled(true);
        }
    }
}

