/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.editor;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.dialog.DialogRegistry;
import su.nightexpress.sunlight.module.kits.KitsModule;
import su.nightexpress.sunlight.module.kits.config.KitsLang;
import su.nightexpress.sunlight.module.kits.dialog.KitDialogKeys;
import su.nightexpress.sunlight.module.kits.model.Kit;

public class KitsEditorMenu
extends AbstractMenu
implements LangContainer {
    private static final IconLocale KIT_OBJECT = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitList.Kit").rawName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Kit: ") + TagWrappers.WHITE.wrap("%kit_name%") + " " + TagWrappers.GRAY.wrap("(ID: %kit_id%)")).br().appendClick("Click to edit").build();
    private static final IconLocale KIT_CREATE = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitList.Creation").accentColor((TagWrapper)TagWrappers.GREEN).rawName("Create a Kit").br().appendClick("Click to create").build();
    private final KitsModule module;
    private final DialogRegistry dialogRegistry;
    private final ItemPopulator<Kit> kitPopulator;

    public KitsEditorMenu(@NotNull SunLightPlugin plugin, @NotNull KitsModule module, @NotNull DialogRegistry dialogRegistry) {
        super((MenuType)MenuType.GENERIC_9X5, KitsLang.EDITOR_TITLE_LIST.text());
        this.module = module;
        this.dialogRegistry = dialogRegistry;
        this.kitPopulator = ItemPopulator.builder(Kit.class).actionProvider(kit -> context -> this.module.openSettingsEditor(context.getPlayer(), (Kit)kit)).itemProvider((context, kit) -> kit.definition().getIcon().hideAllComponents().localized(KIT_OBJECT).replace(builder -> builder.with(kit.placeholders()))).slots(IntStream.range(0, 36).toArray()).build();
        plugin.injectLang(this);
        this.load(plugin);
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(36, 45).toArray());
        this.addNextPageItem(Material.ARROW, new int[]{44});
        this.addPreviousPageItem(Material.ARROW, new int[]{36});
        this.addDefaultButton("create", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ANVIL).localized(KIT_CREATE)).action(context -> this.dialogRegistry.show(context.getPlayer(), KitDialogKeys.KIT_CREATION, this.module, () -> context.getViewer().refresh())).build()).slots(new int[]{40}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        this.kitPopulator.populateTo(context, this.module.getKits(), items);
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

