/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits;

import java.util.Optional;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.sunlight.SunLightPlugin;

public class KitsUtils {
    public static NamespacedKey itemOwnerKey;

    public static void loadKeys(@NotNull SunLightPlugin plugin) {
        itemOwnerKey = new NamespacedKey((Plugin)plugin, "kits.item_owner");
    }

    @NotNull
    public static Optional<UUID> getItemOwner(@NotNull ItemStack item) {
        String data = PDCUtil.getString((ItemStack)item, (NamespacedKey)itemOwnerKey).orElse(null);
        return data == null ? Optional.empty() : Optional.of(UUID.fromString(data));
    }

    public static void setItemOwner(@NotNull ItemStack item, @NotNull Entity entity) {
        KitsUtils.setItemOwner(item, entity.getUniqueId());
    }

    public static void setItemOwner(@NotNull ItemStack item, @NotNull UUID uuid) {
        PDCUtil.set((ItemStack)item, (NamespacedKey)itemOwnerKey, (String)uuid.toString());
    }

    public static boolean isItemOwner(@NotNull ItemStack item, @NotNull Entity entity) {
        return KitsUtils.isItemOwner(item, entity.getUniqueId());
    }

    public static boolean isItemOwner(@NotNull ItemStack item, @NotNull UUID uuid) {
        Optional<UUID> ownerId = KitsUtils.getItemOwner(item);
        return ownerId.isEmpty() || ownerId.get().equals(uuid);
    }
}

