/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.inventories.command;

import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.inventories.InventoriesModule;
import su.nightexpress.sunlight.module.inventories.InventoriesPerms;
import su.nightexpress.sunlight.nms.SunNMS;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.utils.ItemStackUtils;

public class EnderchestCommandsProvider
extends AbstractCommandProvider {
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_FILL = "fill";
    private static final String COMMAND_OPEN = "open";
    private static final String COMMAND_REPAIR = "repair";
    private static final Permission PERMISSION_HUB = InventoriesPerms.COMMAND.permission("enderchest.hub");
    private static final Permission PERMISSION_CLEAR = InventoriesPerms.COMMAND.permission("enderchest.clear");
    private static final Permission PERMISSION_CLEAR_OTHERS = InventoriesPerms.COMMAND.permission("enderchest.clear.others");
    private static final Permission PERMISSION_COPY = InventoriesPerms.COMMAND.permission("enderchest.copy");
    private static final Permission PERMISSION_FILL = InventoriesPerms.COMMAND.permission("enderchest.fill");
    private static final Permission PERMISSION_OPEN = InventoriesPerms.COMMAND.permission("enderchest.open");
    private static final Permission PERMISSION_OPEN_OTHERS = InventoriesPerms.COMMAND.permission("enderchest.open.others");
    private static final Permission PERMISSION_REPAIR = InventoriesPerms.COMMAND.permission("enderchest.repair");
    private static final Permission PERMISSION_REPAIR_OTHERS = InventoriesPerms.COMMAND.permission("enderchest.repair.others");
    private static final TextLocale DESCRIPTION_HUB = LangEntry.builder((String)"Command.Enderchest.Hub.Desc").text("Ender Chest commands.");
    private static final TextLocale DESCRIPTION_CLEAR = LangEntry.builder((String)"Command.Enderchest.Clear.Desc").text("Clear Ender Chest.");
    private static final TextLocale DESCRIPTION_COPY = LangEntry.builder((String)"Command.Enderchest.Copy.Desc").text("Copy player's Ender Chest.");
    private static final TextLocale DESCRIPTION_FILL = LangEntry.builder((String)"Command.Enderchest.Fill.Desc").text("Fill Ender Chest with specified item.");
    private static final TextLocale DESCRIPTION_OPEN = LangEntry.builder((String)"Command.Enderchest.Open.Desc").text("Open Ender Chest.");
    private static final TextLocale DESCRIPTION_REPAIR = LangEntry.builder((String)"Command.Enderchest.Repair.Desc").text("Repair all Ender Chest items.");
    private static final MessageLocale MESSAGE_CLEAR_TARGETTED = LangEntry.builder((String)"Command.Enderchest.Clear.Done.Target").chatMessage(Sound.BLOCK_FIRE_EXTINGUISH, new String[]{TagWrappers.GRAY.wrap("You have cleared " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest."))});
    private static final MessageLocale MESSAGE_CLEAR_NOTIFY = LangEntry.builder((String)"Command.Enderchest.Clear.Done.Notify").chatMessage(Sound.BLOCK_FIRE_EXTINGUISH, new String[]{TagWrappers.GRAY.wrap("Your " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest") + " has been cleared.")});
    private static final MessageLocale MESSAGE_COPY_NOTIFY = LangEntry.builder((String)"Command.Enderchest.Copy.Done.Executor").chatMessage(Sound.ITEM_ARMOR_EQUIP_LEATHER, new String[]{TagWrappers.GRAY.wrap("You have copied " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest") + " content to yours.")});
    private static final MessageLocale MESSAGE_COPY_YOURSELF = LangEntry.builder((String)"Inventories.Command.Enderchest.Copy.NotYourself").chatMessage(Sound.ENTITY_VILLAGER_NO, new String[]{TagWrappers.GRAY.wrap("You can not copy your own " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest") + ".")});
    private static final MessageLocale MESSAGE_FILL_TARGETTED = LangEntry.builder((String)"Command.Enderchest.Fill.Done.Executor").chatMessage(Sound.ENTITY_ITEM_PICKUP, new String[]{TagWrappers.GRAY.wrap("You have filled " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest") + " with " + TagWrappers.WHITE.wrap("%item%."))});
    private static final MessageLocale MESSAGE_OPEN_NOTIFY = LangEntry.builder((String)"Command.Enderchest.Open.Notify").chatMessage(Sound.BLOCK_ENDER_CHEST_OPEN, new String[]{TagWrappers.GRAY.wrap("You have opened your " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest."))});
    private static final MessageLocale MESSAGE_OPEN_TARGETTED = LangEntry.builder((String)"Command.Enderchest.Open.Targetted").chatMessage(Sound.BLOCK_ENDER_CHEST_OPEN, new String[]{TagWrappers.GRAY.wrap("You have opened " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest."))});
    private static final MessageLocale MESSAGE_REPAIR_NOTIFY = LangEntry.builder((String)"Command.Enderchest.Repair.Notify").chatMessage(Sound.BLOCK_ANVIL_USE, new String[]{TagWrappers.GRAY.wrap("All items in your " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest") + " has been repaired.")});
    private static final MessageLocale MESSAGE_REPAIR_TARGETTED = LangEntry.builder((String)"Command.Enderchest.Repair.Target").chatMessage(Sound.BLOCK_ANVIL_USE, new String[]{TagWrappers.GRAY.wrap("You have repaired all items in " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.SOFT_PURPLE.wrap("Ender Chest."))});
    private final InventoriesModule module;
    private final UserManager userManager;
    private final SunNMS internals;

    public EnderchestCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull InventoriesModule module, @NotNull UserManager userManager, @Nullable SunNMS internals) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
        this.internals = internals;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_CLEAR, false, new String[]{"enderclear", "clearender"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_CLEAR)).permission(PERMISSION_CLEAR)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_CLEAR_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::executeClear));
        this.registerLiteral(COMMAND_COPY, false, new String[]{"endercopy", "copyender"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(DESCRIPTION_COPY)).permission(PERMISSION_COPY)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player")}).executes(this::executeCopy));
        this.registerLiteral(COMMAND_FILL, false, new String[]{"enderfill", "fillender"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_FILL)).permission(PERMISSION_FILL)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), Arguments.itemType((String)"item")}).executes(this::executeFill));
        this.registerLiteral(COMMAND_OPEN, true, new String[]{"ec", "endersee"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(DESCRIPTION_OPEN)).permission(PERMISSION_OPEN)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_OPEN_OTHERS)).optional()}).executes(this::executeOpen));
        this.registerLiteral(COMMAND_REPAIR, false, new String[]{"repairender", "fixender"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_REPAIR)).permission(PERMISSION_REPAIR)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_REPAIR_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::executeRepair));
        this.registerRoot("EnderChest", true, new String[]{"enderchest", "echest"}, Map.of(COMMAND_CLEAR, COMMAND_CLEAR, COMMAND_COPY, COMMAND_COPY, COMMAND_FILL, COMMAND_FILL, COMMAND_OPEN, COMMAND_OPEN, COMMAND_REPAIR, COMMAND_REPAIR), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_HUB)).permission(PERMISSION_HUB));
    }

    private @NonNull Optional<Inventory> getEnderChest(@NonNull CommandContext context, @NonNull Player target) {
        if (this.internals != null) {
            return Optional.of(this.internals.getPlayerEnderChest(target));
        }
        if (!target.isOnline()) {
            this.module.sendPrefixed(Lang.ERROR_NO_INTERNALS_HANDLER, context.getSender());
            return Optional.empty();
        }
        return Optional.of(target.getEnderChest());
    }

    public boolean executeClear(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerAndRunInMainThread(context, arguments, (Module)this.module, this.userManager, (Player target) -> this.getEnderChest(context, (Player)target).ifPresent(inventory -> {
            inventory.clear();
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_CLEAR_TARGETTED, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_CLEAR_NOTIFY, (CommandSender)target);
            }
        }));
    }

    public boolean executeCopy(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        return this.loadPlayerAndRunInMainThread(context, arguments, (Module)this.module, this.userManager, (Player target) -> {
            if (target == player) {
                this.module.sendPrefixed(MESSAGE_COPY_YOURSELF, context.getSender());
                return;
            }
            Inventory invFrom = this.getEnderChest(context, (Player)target).orElse(null);
            Inventory invTo = this.getEnderChest(context, player).orElse(null);
            if (invFrom == null || invTo == null) {
                return;
            }
            for (int slot = 0; slot < invTo.getSize(); ++slot) {
                invTo.setItem(slot, invFrom.getItem(slot));
            }
            this.module.sendPrefixed(MESSAGE_COPY_NOTIFY, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
        });
    }

    public boolean executeFill(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerAndRunInMainThread(context, arguments, (Module)this.module, this.userManager, (Player target) -> this.getEnderChest(context, (Player)target).ifPresent(inventory -> {
            Material material = arguments.getMaterial("item");
            for (int slot = 0; slot < inventory.getSize(); ++slot) {
                ItemStack has = inventory.getItem(slot);
                if (has != null && !has.getType().isAir()) continue;
                inventory.setItem(slot, new ItemStack(material));
            }
            this.module.sendPrefixed(MESSAGE_FILL_TARGETTED, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)).with("%item%", () -> LangUtil.getSerializedName((Material)material)));
        }));
    }

    public boolean executeOpen(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerAndRunInMainThread(context, arguments, (Module)this.module, this.userManager, (Player target) -> this.getEnderChest(context, (Player)target).ifPresent(inventory -> {
            Player player = context.getPlayerOrThrow();
            player.openInventory(inventory);
            if (player != target) {
                this.module.sendPrefixed(MESSAGE_OPEN_TARGETTED, (CommandSender)player, builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
            } else {
                this.module.sendPrefixed(MESSAGE_OPEN_NOTIFY, (CommandSender)player);
            }
        }));
    }

    public boolean executeRepair(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerAndRunInMainThread(context, arguments, (Module)this.module, this.userManager, (Player target) -> this.getEnderChest(context, (Player)target).ifPresent(inventory -> {
            inventory.forEach(ItemStackUtils::repairItem);
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_REPAIR_TARGETTED, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_REPAIR_NOTIFY, (CommandSender)target);
            }
        }));
    }
}

