/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.inventories.command;

import java.util.HashMap;
import java.util.stream.Stream;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.EnumLocale;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.sound.VanillaSound;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.api.PortableContainer;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.inventories.InventoriesModule;
import su.nightexpress.sunlight.module.inventories.InventoriesPerms;
import su.nightexpress.sunlight.nms.SunNMS;

public class ContainerCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION_ROOT = InventoriesPerms.COMMAND.permission("container.root");
    private static final Permission PERMISSION_OTHERS = InventoriesPerms.COMMAND.permission("container.others");
    private static final Permission PERMISSION_ANVIL = InventoriesPerms.COMMAND.permission("container.anvil");
    private static final Permission PERMISSION_LOOM = InventoriesPerms.COMMAND.permission("container.loom");
    private static final Permission PERMISSION_WORKBENCH = InventoriesPerms.COMMAND.permission("container.workbench");
    private static final Permission PERMISSION_SMITHING = InventoriesPerms.COMMAND.permission("container.smithing_table");
    private static final Permission PERMISSION_GRINDSTONE = InventoriesPerms.COMMAND.permission("container.grindstone");
    private static final Permission PERMISSION_CARTOGRAPHY = InventoriesPerms.COMMAND.permission("container.cartography_table");
    private static final Permission PERMISSION_ENCHANTING = InventoriesPerms.COMMAND.permission("container.enchanting_table");
    private static final Permission PERMISSION_STONECUTTER = InventoriesPerms.COMMAND.permission("container.stonecutter");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Container.Root.Desc").text("Portable Container commands.");
    private static final TextLocale DESCRIPTION_TYPE = LangEntry.builder((String)"Command.Container.Type.Desc").text("Opens Portable %type%.");
    private static final MessageLocale MESSAGE_NOTIFY = LangEntry.builder((String)"Command.Container.Notify").chatMessage(TagWrappers.GRAY.wrap("You have opened " + TagWrappers.SOFT_AQUA.wrap("Portable %type%.")));
    private static final MessageLocale MESSAGE_TARGETTED = LangEntry.builder((String)"Command.Container.Target").chatMessage(TagWrappers.GRAY.wrap("You have opened " + TagWrappers.SOFT_YELLOW.wrap("Portable %type%") + " for " + TagWrappers.SOFT_YELLOW.wrap("%player_display_name%.")));
    private static final EnumLocale<PortableContainer> CONTAINER_LOCALE = LangEntry.builder((String)"MenuType").enumeration(PortableContainer.class);
    private final InventoriesModule module;
    private final SunNMS nms;

    public ContainerCommandProvider(@NotNull SunLightPlugin plugin, @NotNull InventoriesModule module, @NotNull SunNMS nms) {
        super(plugin);
        this.module = module;
        this.nms = nms;
    }

    @NotNull
    private Permission getPermission(@NotNull PortableContainer container) {
        return switch (container) {
            default -> throw new MatchException(null, null);
            case PortableContainer.ANVIL -> PERMISSION_ANVIL;
            case PortableContainer.LOOM -> PERMISSION_LOOM;
            case PortableContainer.WORKBENCH -> PERMISSION_WORKBENCH;
            case PortableContainer.SMITHING_TABLE -> PERMISSION_SMITHING;
            case PortableContainer.GRINDSTONE -> PERMISSION_GRINDSTONE;
            case PortableContainer.CARTOGRAPHY_TABLE -> PERMISSION_CARTOGRAPHY;
            case PortableContainer.ENCHANTING_TABLE -> PERMISSION_ENCHANTING;
            case PortableContainer.STONECUTTER -> PERMISSION_STONECUTTER;
        };
    }

    @NotNull
    private Sound getSound(@NotNull PortableContainer container) {
        return switch (container) {
            default -> throw new MatchException(null, null);
            case PortableContainer.ANVIL -> Sound.BLOCK_ANVIL_PLACE;
            case PortableContainer.LOOM -> Sound.UI_LOOM_SELECT_PATTERN;
            case PortableContainer.WORKBENCH -> Sound.BLOCK_WOOD_PLACE;
            case PortableContainer.SMITHING_TABLE -> Sound.BLOCK_SMITHING_TABLE_USE;
            case PortableContainer.GRINDSTONE -> Sound.BLOCK_GRINDSTONE_USE;
            case PortableContainer.CARTOGRAPHY_TABLE -> Sound.UI_CARTOGRAPHY_TABLE_TAKE_RESULT;
            case PortableContainer.ENCHANTING_TABLE -> Sound.BLOCK_ENCHANTMENT_TABLE_USE;
            case PortableContainer.STONECUTTER -> Sound.UI_STONECUTTER_TAKE_RESULT;
        };
    }

    @Override
    public void registerDefaults() {
        HashMap<String, String> childrens = new HashMap<String, String>();
        Stream.of(PortableContainer.values()).forEach(container -> {
            Permission permission = this.getPermission((PortableContainer)((Object)container));
            String nodeId = LowerCase.INTERNAL.apply(container.name());
            String alias = nodeId.replace("_", "");
            this.registerLiteral(nodeId, true, new String[]{alias}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_TYPE.text().replace("%type%", CONTAINER_LOCALE.getLocalized((Enum)container)))).permission(permission)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.open(context, arguments, (PortableContainer)((Object)container))));
            childrens.put(nodeId, alias);
        });
        this.registerRoot("Container", true, new String[]{"container"}, childrens, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERMISSION_ROOT));
    }

    private boolean open(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull PortableContainer container) {
        return this.runForOnlinePlayerOrSender(context, arguments, this.module, target -> {
            this.nms.openContainer((Player)target, container);
            VanillaSound.of((Sound)this.getSound(container)).play(target);
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_TARGETTED, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)).with("%type%", () -> CONTAINER_LOCALE.getLocalized((Enum)container)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_NOTIFY, (CommandSender)target, builder -> builder.with("%type%", () -> CONTAINER_LOCALE.getLocalized((Enum)container)));
            }
            return true;
        });
    }
}

