/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.homes.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.homes.HomesModule;
import su.nightexpress.sunlight.module.homes.config.HomesLang;
import su.nightexpress.sunlight.module.homes.impl.Home;

public class IconSelectionMenu
extends AbstractObjectMenu<Home> {
    private final HomesModule module;
    private ItemPopulator<HomeIcon> iconPopulator;

    public IconSelectionMenu(@NotNull SunLightPlugin plugin, @NotNull HomesModule module) {
        super((MenuType)MenuType.GENERIC_9X4, "Icon Selection", Home.class);
        this.module = module;
        this.load(plugin, FileConfig.load((String)module.getLocalUIPath(), (String)"home_icon.yml"));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(27, 36).toArray());
        this.addDefaultButton("return", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.IRON_DOOR).setDisplayName(TagWrappers.WHITE.wrap("Return"))).action(context -> this.module.openHomeSettings(context.getPlayer(), (Home)this.getObject((ViewerContext)context))).build()).slots(new int[]{31}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
        int[] iconSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Icons.Slots", (Object)IntStream.range(0, 27).toArray(), (String[])new String[0]).resolveWithDefaults(config);
        this.iconPopulator = ItemPopulator.builder(HomeIcon.class).actionProvider(homeIcon -> context -> {
            Home home = (Home)this.getObject((ViewerContext)context);
            home.setIconId(homeIcon.id());
            home.markDirty();
            this.module.openHomeSettings(context.getPlayer(), (Home)this.getObject((ViewerContext)context));
        }).itemProvider((context, homeIcon) -> {
            ItemStack itemStack = homeIcon.adaptedItem.getItemStack();
            if (itemStack == null) {
                return NightItem.fromType((Material)Material.AIR);
            }
            return NightItem.fromItemStack((ItemStack)itemStack).localized(HomesLang.UI_ICON_SELECTION_ICON).replace(builder -> builder.with("%name%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack))).hideAllComponents();
        }).slots(iconSlots).build();
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        ArrayList icons = new ArrayList();
        this.module.getSettings().getIconPresets().forEach((id, item) -> icons.add(new HomeIcon((String)id, (AdaptedItem)item)));
        this.iconPopulator.populateTo(context, icons, items);
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    private record HomeIcon(@NotNull String id, @NotNull AdaptedItem adaptedItem) {
    }
}

