/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.homes.menu;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.dialog.DialogRegistry;
import su.nightexpress.sunlight.module.homes.HomesModule;
import su.nightexpress.sunlight.module.homes.dialog.HomeDialogKeys;
import su.nightexpress.sunlight.module.homes.impl.Home;
import su.nightexpress.sunlight.module.homes.impl.HomeType;

public class HomeSettingsMenu
extends AbstractObjectMenu<Home> {
    private final HomesModule module;
    private final DialogRegistry dialogRegistry;

    public HomeSettingsMenu(@NotNull SunLightPlugin plugin, @NotNull HomesModule module, @NotNull DialogRegistry dialogRegistry) {
        super((MenuType)MenuType.GENERIC_9X5, "Home Settings", Home.class);
        this.module = module;
        this.dialogRegistry = dialogRegistry;
        this.load(plugin, FileConfig.load((String)module.getLocalUIPath(), (String)"home_settings.yml"));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(0, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(36, 45).toArray());
        this.addDefaultButton("return", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.IRON_DOOR).setDisplayName(TagWrappers.WHITE.wrap("Return"))).action(context -> this.module.openHomes(context.getPlayer(), ((Home)this.getObject((ViewerContext)context)).getOwner().id())).build()).slots(new int[]{40}).build());
        this.addDefaultButton("name", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.NAME_TAG).setDisplayName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Display Name")).setLore(Lists.newList((Object[])new String[]{TagWrappers.WHITE.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.YELLOW.wrap("%home_name%"), "", TagWrappers.YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to change"))}))).displayModifier((context, item) -> item.replace(builder -> builder.with(((Home)this.getObject(context)).placeholders()))).action(context -> this.dialogRegistry.show(context.getPlayer(), HomeDialogKeys.HOME_NAME, (Home)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{19}).build());
        this.addDefaultButton("type", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ENDER_EYE).setDisplayName(TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("Type")).setLore(Lists.newList((Object[])new String[]{TagWrappers.WHITE.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.GREEN.wrap("%home_type%"), "", TagWrappers.GRAY.wrap("Public homes are open for everyone."), TagWrappers.GRAY.wrap("Private homes requires an invite."), "", TagWrappers.GREEN.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to toggle"))}))).displayModifier((context, item) -> item.replace(builder -> builder.with(((Home)this.getObject(context)).placeholders()))).action(context -> {
            Home home = (Home)this.getObject((ViewerContext)context);
            home.setType((HomeType)Lists.next((Enum)home.getType()));
            home.markDirty();
            context.getViewer().refresh();
        }).build()).slots(new int[]{21}).build());
        this.addDefaultButton("favorite", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.NETHER_STAR).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Favorite")).setLore(Lists.newList((Object[])new String[]{TagWrappers.WHITE.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Favorite: ") + TagWrappers.GOLD.wrap("%home_favorite%"), "", TagWrappers.GRAY.wrap("Favorite home is used by default"), TagWrappers.GRAY.wrap("in all home commands and as"), TagWrappers.GRAY.wrap("respawn point."), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to toggle"))}))).displayModifier((context, item) -> item.replace(builder -> builder.with(((Home)this.getObject(context)).placeholders()))).action(context -> {
            Home home = (Home)this.getObject((ViewerContext)context);
            Home oldFavorite = this.module.getFavoriteHome(context.getPlayer());
            if (oldFavorite != null && oldFavorite != home) {
                oldFavorite.setFavorite(false);
                oldFavorite.markDirty();
            }
            home.setFavorite(!home.isFavorite());
            home.markDirty();
            context.getViewer().refresh();
        }).build()).slots(new int[]{4}).build());
        this.addDefaultButton("icon", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ITEM_FRAME).setDisplayName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Icon")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Select an icon for your home!"), "", TagWrappers.YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to change"))}))).displayModifier((context, item) -> item.replace(builder -> builder.with(((Home)this.getObject(context)).placeholders()))).action(context -> this.module.openIconSelection(context.getPlayer(), (Home)this.getObject((ViewerContext)context))).build()).slots(new int[]{23}).build());
        this.addDefaultButton("invited_players", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.WRITABLE_BOOK).setDisplayName(TagWrappers.ORANGE.and((TagWrapper)TagWrappers.BOLD).wrap("Invited Players")).setLore(Lists.newList((Object[])new String[]{TagWrappers.WHITE.wrap("\u00bb ") + TagWrappers.GRAY.wrap("Players Invited: ") + TagWrappers.ORANGE.wrap("%home_invited_players%"), "", TagWrappers.GRAY.wrap("Share your home with friends!"), "", TagWrappers.ORANGE.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))}))).condition(context -> ((Home)this.getObject(context)).isPrivate()).displayModifier((context, item) -> item.replace(builder -> builder.with(((Home)this.getObject(context)).placeholders()))).action(context -> this.module.openInvitedPlayersMenu(context.getPlayer(), (Home)this.getObject((ViewerContext)context))).build()).slots(new int[]{25}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

