/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.homes.dialog.impl;

import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.homes.HomesModule;
import su.nightexpress.sunlight.module.homes.impl.Home;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.utils.FutureUtils;

public class HomeInvitePlayerDialog
extends Dialog<Home> {
    private final SunLightPlugin plugin;
    private final HomesModule module;
    private final UserManager userManager;
    private static final TextLocale TITLE = LangEntry.builder((String)"Homes.Dialog.InvitePlayer.Title").text(HomeInvitePlayerDialog.title("Home", "Invite Player"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Homes.Dialog.InvitePlayer.Body").dialogElement(400, new String[]{"Enter a name of the player you want to invite to your home."});
    private static final TextLocale INPUT_NAME = LangEntry.builder((String)"Homes.Dialog.InvitePlayer.Input.PlayerName").text("Player Name");
    private static final String JSON_NAME = "name";

    public HomeInvitePlayerDialog(@NotNull SunLightPlugin plugin, @NotNull HomesModule module, @NotNull UserManager userManager) {
        this.plugin = plugin;
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Home home) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_NAME, (TextLocale)INPUT_NAME).maxLength(24).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            String name = nbtHolder.getText(JSON_NAME, home.getName());
            if (name.isBlank()) {
                return;
            }
            ((CompletableFuture)this.userManager.loadTargetProfile(name).thenAcceptAsync(profile -> {
                if (profile == null) {
                    this.module.sendPrefixed(CoreLang.ERROR_INVALID_PLAYER, (CommandSender)player);
                    return;
                }
                if (this.module.inviteToHome(player, home, (UserInfo)profile)) {
                    viewer.callback();
                }
            }, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0))).whenComplete(FutureUtils::printStacktrace);
        }).build();
    }
}

