/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.greetings;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.greetings.message.GreetingMessage;
import su.nightexpress.sunlight.module.greetings.message.MessageType;

public class GreetingsSettings
extends AbstractConfig {
    private static final ConfigType<GreetingMessage> MESSAGE_CONFIG_TYPE = ConfigType.of(GreetingMessage::read, FileConfig::set);
    private final ConfigProperty<Map<String, GreetingMessage>> joinMessages = this.addProperty(ConfigTypes.forMapWithLowerKeys(MESSAGE_CONFIG_TYPE), "Messages.Join", GreetingsSettings.getDefaultJoins(), new String[]{"Create custom join messages here.", "[>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "[>] Placeholders to use in messages:", "- %player_name% -> Player name.", "- %player_display_name% -> Player display (custom) name.", "- %player_prefix% -> Player prefix (from permissions plugin).", "- %player_suffix% -> Player name (from permissions plugin).", "- PlaceholderAPI"});
    private final ConfigProperty<Map<String, GreetingMessage>> quitMessages = this.addProperty(ConfigTypes.forMapWithLowerKeys(MESSAGE_CONFIG_TYPE), "Messages.Quit", GreetingsSettings.getDefaultQuits(), new String[]{"Create custom quit messages here.", "[>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "[>] Placeholders to use in messages:", "- %player_name% -> Player name.", "- %player_display_name% -> Player display (custom) name.", "- %player_prefix% -> Player prefix (from permissions plugin).", "- %player_suffix% -> Player name (from permissions plugin).", "- PlaceholderAPI"});

    @NotNull
    private static Map<String, GreetingMessage> getDefaultJoins() {
        HashMap<String, GreetingMessage> map = new HashMap<String, GreetingMessage>();
        map.put("default", new GreetingMessage(0, TagWrappers.GRAY.wrap("[" + TagWrappers.GREEN.wrap("+") + "] %player_prefix%%player_display_name%"), Set.of("*")));
        return map;
    }

    @NotNull
    private static Map<String, GreetingMessage> getDefaultQuits() {
        HashMap<String, GreetingMessage> map = new HashMap<String, GreetingMessage>();
        map.put("default", new GreetingMessage(0, TagWrappers.GRAY.wrap("[" + TagWrappers.RED.wrap("-") + "] %player_prefix%%player_display_name%"), Set.of("*")));
        return map;
    }

    @NotNull
    public Map<String, GreetingMessage> getMessages(@NotNull MessageType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MessageType.JOIN -> this.getJoinMessages();
            case MessageType.QUIT -> this.getQuitMessages();
        };
    }

    @NotNull
    public Map<String, GreetingMessage> getJoinMessages() {
        return (Map)this.joinMessages.get();
    }

    @NotNull
    public Map<String, GreetingMessage> getQuitMessages() {
        return (Map)this.quitMessages.get();
    }
}

