/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.extras.listener;

import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.text.NightMessage;
import su.nightexpress.nightcore.util.text.tag.TagPool;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.extras.ExtrasModule;
import su.nightexpress.sunlight.module.extras.config.ExtrasConfig;
import su.nightexpress.sunlight.module.extras.config.ExtrasPerms;
import su.nightexpress.sunlight.user.SunUser;

public class ExtrasGenericListener
extends AbstractListener<SunLightPlugin> {
    public ExtrasGenericListener(@NotNull SunLightPlugin plugin, @NotNull ExtrasModule module) {
        super((NightCorePlugin)plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoinCommands(PlayerJoinEvent event) {
        if (!((Boolean)ExtrasConfig.JOIN_COMMANDS_ENABLED.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
        List commands = user.isFirstTimeJoined() ? (List)ExtrasConfig.JOIN_COMMANDS_FIRST.get() : (List)ExtrasConfig.JOIN_COMMANDS_DEFAULT.get();
        Players.dispatchCommands((Player)player, (List)commands);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSignsColor(SignChangeEvent event) {
        if (!((Boolean)ExtrasConfig.SIGN_COLORS_ENABLED.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission(ExtrasPerms.SIGNS_COLOR)) {
            return;
        }
        for (int index = 0; index < event.getLines().length; ++index) {
            String line = event.getLine(index);
            if (line == null) continue;
            event.setLine(index, NightMessage.from((String)line, (TagPool)TagPool.BASE_COLORS_AND_STYLES).toLegacy());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnvilColor(PrepareAnvilEvent event) {
        if (!((Boolean)ExtrasConfig.ANVIL_COLORS_ENABLED.get()).booleanValue()) {
            return;
        }
        if (event.getViewers().isEmpty()) {
            return;
        }
        ItemStack result = event.getResult();
        if (result == null || result.getType().isAir()) {
            return;
        }
        Player player = (Player)event.getViewers().getFirst();
        if (!player.hasPermission(ExtrasPerms.ANVILS_COLOR)) {
            return;
        }
        ItemUtil.editMeta((ItemStack)result, meta -> meta.setDisplayName(NightMessage.from((String)meta.getDisplayName(), (TagPool)TagPool.BASE_COLORS_AND_STYLES).toLegacy()));
        event.setResult(result);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onKeepInventoryDeath(PlayerDeathEvent event) {
        if (!((Boolean)ExtrasConfig.KEEP_INVENTORY_ENABLED.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        Set ranks = Players.getPermissionGroups((Player)player);
        if (ranks.stream().anyMatch(rank -> ((List)ExtrasConfig.KEEP_INVENTORY_XP_RANKS.get()).contains(rank))) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
        if (ranks.stream().anyMatch(rank -> ((List)ExtrasConfig.KEEP_INVENTORY_ITEMS_RANKS.get()).contains(rank))) {
            event.setKeepInventory(true);
            event.getDrops().clear();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFarmKillerEnderEndermite(EntityTargetEvent event) {
        if (!((Boolean)ExtrasConfig.ANTI_FARM_ENDERMITE_MINECART.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Enderman)) {
            return;
        }
        Enderman enderman = (Enderman)entity;
        Entity entity2 = event.getTarget();
        if (!(entity2 instanceof Endermite)) {
            return;
        }
        Endermite endermite = (Endermite)entity2;
        event.setCancelled(endermite.isInsideVehicle());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFarmKillerFishingAuto(PlayerInteractEvent event) {
        if (!((Boolean)ExtrasConfig.ANTI_FARM_AUTO_FISHING.get()).booleanValue()) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack main = player.getInventory().getItemInMainHand();
        ItemStack off = player.getInventory().getItemInOffHand();
        if (!this.isFishingRod(main) && !this.isFishingRod(off)) {
            return;
        }
        Material blockType = block.getType();
        if (!blockType.isInteractable() && blockType.isSolid()) {
            return;
        }
        player.getNearbyEntities(16.0, 16.0, 16.0).stream().filter(entity -> entity instanceof FishHook).map(entity -> (FishHook)entity).filter(fishHook -> fishHook.getShooter() instanceof Player && fishHook.getShooter().equals((Object)player)).forEach(Entity::remove);
    }

    private boolean isFishingRod(@NotNull ItemStack item) {
        return !item.getType().isAir() && item.getType() == Material.FISHING_ROD;
    }
}

