/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.extras.chairs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.extras.ExtrasModule;
import su.nightexpress.sunlight.module.extras.chairs.ChairsListener;
import su.nightexpress.sunlight.module.extras.config.ExtrasConfig;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserProperty;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class ChairsManager
extends AbstractManager<SunLightPlugin> {
    public static final UserProperty<Boolean> SETTING_CHAIRS = UserProperty.create("chairs.enabled", Boolean.class, true, true);
    private static final String SEAT_META = "seat";
    private final Map<Block, ArmorStand> chairHolders = new HashMap<Block, ArmorStand>();

    public ChairsManager(@NotNull SunLightPlugin plugin, @NotNull ExtrasModule module) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.loadCommands();
        UserPropertyRegistry.register(SETTING_CHAIRS);
        this.addListener((SimpeListener)new ChairsListener((SunLightPlugin)this.plugin, this));
    }

    protected void onShutdown() {
        for (Player player : ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers()) {
            this.standUp(player, true);
        }
        this.chairHolders.values().forEach(Entity::remove);
        this.chairHolders.clear();
    }

    private void loadCommands() {
    }

    public static boolean isChairsEnabled(@NotNull SunUser user) {
        return user.getPropertyOrDefault(SETTING_CHAIRS);
    }

    @NotNull
    private ArmorStand createChairHolder(@NotNull Player player, @NotNull Block chair) {
        Vector vector;
        BlockData blockData = chair.getBlockData();
        if (blockData instanceof Directional) {
            Directional directional = (Directional)blockData;
            BlockFace facing = directional.getFacing();
            Location blockLoc = chair.getLocation();
            Location faceLoc = chair.getRelative(facing.getOppositeFace()).getLocation();
            vector = faceLoc.clone().subtract(blockLoc.toVector()).toVector();
        } else {
            vector = player.getLocation().getDirection();
        }
        Location holderLoc = this.getHolderLocation(chair).setDirection(vector);
        ArmorStand armorStand = (ArmorStand)player.getWorld().spawn(holderLoc, ArmorStand.class);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setInvulnerable(true);
        armorStand.setMarker(true);
        armorStand.setCollidable(false);
        armorStand.setRemoveWhenFarAway(true);
        armorStand.setPersistent(false);
        armorStand.setMetadata(SEAT_META, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)chair.getLocation()));
        this.chairHolders.put(chair, armorStand);
        return armorStand;
    }

    @NotNull
    private Location getHolderLocation(@NotNull Block chair) {
        Location seat = LocationUtil.setCenter2D((Location)chair.getLocation());
        double dY = 0.0;
        double height = chair.getBoundingBox().getHeight();
        BlockData data = chair.getBlockData();
        if (data instanceof Slab) {
            Slab slab = (Slab)data;
            if (slab.getType() == Slab.Type.TOP) {
                height *= 2.0;
            }
        } else if (data instanceof Stairs) {
            Stairs stairs = (Stairs)data;
            height = 0.5;
        }
        double normalized = -(dY - height);
        return seat.add(0.0, normalized, 0.0);
    }

    @Nullable
    private ArmorStand getChairHolder(@NotNull Player player) {
        if (!this.isSit(player)) {
            return null;
        }
        return (ArmorStand)player.getVehicle();
    }

    public void standUp(@NotNull Player player, boolean force) {
        this.standUp(player, null, force);
    }

    public void standUp(@NotNull Player player, @Nullable ArmorStand stand, boolean force) {
        if (stand == null) {
            stand = this.getChairHolder(player);
        }
        if (stand == null || !stand.hasMetadata(SEAT_META)) {
            return;
        }
        Location chairBlockLocation = (Location)((MetadataValue)stand.getMetadata(SEAT_META).getFirst()).value();
        if (chairBlockLocation == null) {
            return;
        }
        Block chairBlock = chairBlockLocation.getBlock();
        if (!this.chairHolders.containsKey(chairBlock)) {
            return;
        }
        if (!player.isDead() && !force) {
            Location holderLocation = LocationUtil.setCenter2D((Location)chairBlock.getRelative(BlockFace.UP).getLocation());
            holderLocation.setDirection(player.getLocation().getDirection());
            player.teleport(holderLocation);
        }
        stand.remove();
        this.chairHolders.remove(chairBlock);
    }

    public void sitPlayer(@NotNull Player player, @NotNull Block chair) {
        if (this.isOccupied(chair)) {
            return;
        }
        ArmorStand seat = this.createChairHolder(player, chair);
        seat.addPassenger((Entity)player);
    }

    public boolean isSit(@NotNull Player player) {
        Entity holder = player.getVehicle();
        return holder != null && holder.hasMetadata(SEAT_META);
    }

    public boolean isOccupied(@NotNull Block chair) {
        return this.chairHolders.containsKey(chair);
    }

    public static boolean isChair(@NotNull Block block) {
        if (!block.getRelative(BlockFace.UP).isEmpty()) {
            return false;
        }
        BlockData data = block.getBlockData();
        if (data instanceof Stairs) {
            return (Boolean)ExtrasConfig.CHAIRS_ALLOW_STAIRS.get();
        }
        if (data instanceof Slab) {
            return (Boolean)ExtrasConfig.CHAIRS_ALLOW_SLABS.get();
        }
        if (Version.isAtLeast((Version)Version.V1_19_R3) && Tag.WOOL_CARPETS.isTagged((Keyed)block.getType())) {
            return (Boolean)ExtrasConfig.CHAIRS_ALLOW_CARPETS.get();
        }
        return ((Set)ExtrasConfig.CHAIRS_CUSTOM_BLOCKS.get()).contains(block.getType());
    }
}

