/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.extras;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.extras.chairs.ChairsManager;
import su.nightexpress.sunlight.module.extras.chestsort.SortManager;
import su.nightexpress.sunlight.module.extras.config.ExtrasConfig;
import su.nightexpress.sunlight.module.extras.config.ExtrasLang;
import su.nightexpress.sunlight.module.extras.config.ExtrasPerms;
import su.nightexpress.sunlight.module.extras.listener.ExtrasGenericListener;
import su.nightexpress.sunlight.module.extras.listener.PhysicsExplosionListener;

public class ExtrasModule
extends Module {
    private ChairsManager chairsManager;
    private SortManager sortManager;

    public ExtrasModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        config.initializeOptions(ExtrasConfig.class);
        ((SunLightPlugin)this.plugin).injectLang(ExtrasLang.class);
        if (((Boolean)ExtrasConfig.CHAIRS_ENABLED.get()).booleanValue()) {
            this.chairsManager = new ChairsManager((SunLightPlugin)this.plugin, this);
            this.chairsManager.setup();
        }
        if (((Boolean)ExtrasConfig.CHEST_SORT_ENABLED.get()).booleanValue()) {
            this.sortManager = new SortManager((SunLightPlugin)this.plugin, this);
            this.sortManager.setup();
        }
        if (((Boolean)ExtrasConfig.PHYSIC_EXPLOSIONS_ENABLED.get()).booleanValue()) {
            this.addListener((SimpeListener)new PhysicsExplosionListener((SunLightPlugin)this.plugin));
        }
        this.addListener((SimpeListener)new ExtrasGenericListener((SunLightPlugin)this.plugin, this));
    }

    @Override
    protected void unloadModule() {
        if (this.chairsManager != null) {
            this.chairsManager.shutdown();
        }
        if (this.sortManager != null) {
            this.sortManager.shutdown();
        }
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(ExtrasPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    @Nullable
    public ChairsManager getChairsManager() {
        return this.chairsManager;
    }

    @Nullable
    public SortManager getChestSortManager() {
        return this.sortManager;
    }
}

