/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.listener;

import org.bukkit.command.CommandSender;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.essential.EssentialLang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;

public class InvulnerabilityListener
extends AbstractListener<SunLightPlugin> {
    private final EssentialModule module;
    private final EssentialSettings settings;

    public InvulnerabilityListener(@NonNull SunLightPlugin plugin, @NonNull EssentialModule module, @NonNull EssentialSettings settings) {
        super((NightCorePlugin)plugin);
        this.module = module;
        this.settings = settings;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (!player.isInvulnerable()) {
            return;
        }
        if (player.hasPermission(EssentialPerms.BYPASS_INVULNERABILITY_WORLD)) {
            return;
        }
        if (!this.settings.isInvulnerabilityAllowedInThisWorld(player.getWorld())) {
            player.setInvulnerable(false);
            this.module.sendPrefixed(EssentialLang.INVULNERABILITY_RESTRICTED_WORLD_NOTIFY, (CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onDamageOutgoing(EntityDamageEvent event) {
        MessageLocale locale;
        boolean allowDamage;
        DamageSource source = event.getDamageSource();
        Entity entity = source.getCausingEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.isInvulnerable()) {
            return;
        }
        if (player.hasPermission(EssentialPerms.BYPASS_INVULNERABILITY_DAMAGE)) {
            return;
        }
        Entity victim = event.getEntity();
        if (victim instanceof Player) {
            allowDamage = this.settings.isInvulnerabilityAllowsDamagePlayers();
            locale = EssentialLang.INVULNERABILITY_RESTRICTED_PLAYER_DAMAGE;
        } else if (victim instanceof LivingEntity) {
            allowDamage = this.settings.isInvulnerabilityAllowsDamageMobs();
            locale = EssentialLang.INVULNERABILITY_RESTRICTED_MOB_DAMAGE;
        } else {
            return;
        }
        if (allowDamage) {
            return;
        }
        event.setCancelled(true);
        this.module.sendPrefixed(locale, (CommandSender)player, builder -> builder.with("%type%", () -> EntityUtil.getNameSerialized((Entity)victim)));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFoodChange(FoodLevelChangeEvent event) {
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!player.isInvulnerable()) {
            return;
        }
        if (!this.settings.isInvulnerabilityLocksFoodLevel()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFoodChange(EntityAirChangeEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.isInvulnerable()) {
            return;
        }
        if (!this.settings.isInvulnerabilityLocksOxygenLevel()) {
            return;
        }
        event.setCancelled(true);
    }
}

