/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.bukkit.World;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.language.LangAssets;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.EnumLocale;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;

public class WeatherCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION_ROOT = EssentialPerms.COMMAND.permission("weather.root");
    private static final Permission PERMISSION_CLEAR = EssentialPerms.COMMAND.permission("weather.clear");
    private static final Permission PERMISSION_STORM = EssentialPerms.COMMAND.permission("weather.storm");
    private static final Permission PERMISSION_THUNDERSTORM = EssentialPerms.COMMAND.permission("weather.thunder");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Weather.Root.Desc").text("Weather commands.");
    private static final TextLocale DESCRIPTION_TYPE = LangEntry.builder((String)"Command.Weather.Type.Desc").text("Set world's weather to %type%.");
    private static final MessageLocale MESSAGE_SET_FEEDBACK = LangEntry.builder((String)"Command.Weather.Set").chatMessage(TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%world%") + "'s weather to " + TagWrappers.SOFT_YELLOW.wrap("%type%") + "."));
    private static final EnumLocale<Type> WEATHER_TYPE = LangEntry.builder((String)"WeatherType").enumeration(Type.class);
    private final EssentialModule module;

    public WeatherCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        LinkedHashMap<String, String> rootChildrens = new LinkedHashMap<String, String>();
        for (Type type : Type.values()) {
            String name = LowerCase.INTERNAL.apply(type.name());
            Permission permission = switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> PERMISSION_CLEAR;
                case 1 -> PERMISSION_STORM;
                case 2 -> PERMISSION_THUNDERSTORM;
            };
            this.registerLiteral(name, true, new String[]{name}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_TYPE.text().replace("%type%", WEATHER_TYPE.getLocalized((Enum)type)))).permission(permission)).withArguments(new ArgumentNodeBuilder[]{Arguments.world((String)"world").optional()}).executes((context, arguments) -> this.setWeather(context, arguments, type)));
            rootChildrens.put(name, name);
        }
        this.registerRoot("Weather", true, new String[]{"weather"}, rootChildrens, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERMISSION_ROOT));
    }

    private boolean setWeather(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull Type type) {
        World world = this.getWorld(context, arguments, "world");
        if (world == null) {
            return false;
        }
        type.apply(world);
        this.module.sendPrefixed(MESSAGE_SET_FEEDBACK, context.getSender(), replacer -> replacer.with("%type%", () -> WEATHER_TYPE.getLocalized((Enum)type)).with("%world%", () -> LangAssets.get((World)world)));
        return true;
    }

    public static enum Type {
        CLEAR(world -> {
            world.setStorm(false);
            world.setThundering(false);
        }),
        STORM(world -> {
            world.setThundering(false);
            world.setStorm(true);
        }),
        THUNDERSTORM(world -> {
            world.setStorm(true);
            world.setThundering(true);
        });

        private final Consumer<World> consumer;

        private Type(Consumer<World> consumer) {
            this.consumer = consumer;
        }

        public void apply(@NotNull World world) {
            this.consumer.accept(world);
        }
    }
}

