/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.bukkit.Keyed;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.module.essential.object.TimeAlias;
import su.nightexpress.sunlight.utils.WorldTime;

public class TimeCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION_ROOT = EssentialPerms.COMMAND.permission("time.root");
    private static final Permission PERMISSION_SHOW = EssentialPerms.COMMAND.permission("time.show");
    private static final Permission PERMISSION_SET = EssentialPerms.COMMAND.permission("time.set");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Time.Root.Desc").text("World time commands.");
    private static final TextLocale DESCRIPTION_SHOW = LangEntry.builder((String)"Command.Time.Show.Desc").text("Display current world time.");
    private static final TextLocale DESCRIPTION_SET_TIME = LangEntry.builder((String)"Command.Time.SetTime.Desc").text("Set world's time to %s ticks.");
    private static final TextLocale DESCRIPTION_SET_TICKS = LangEntry.builder((String)"Command.Time.SetTicks.Desc").text("Change time in a world.");
    private static final MessageLocale MESSAGE_SET_FEEDBACK = LangEntry.builder((String)"Command.Time.Set.Done").chatMessage(TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%world%") + "'s time to " + TagWrappers.SOFT_YELLOW.wrap("%time%") + " (" + TagWrappers.WHITE.wrap("%total% ticks") + ")."));
    private static final String COMMAND_SHOW = "show";
    private static final String COMMAND_SET = "set";
    private final EssentialModule module;
    private final EssentialSettings settings;
    private final Set<TimeAlias> timeAliases;

    public TimeCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull EssentialSettings settings) {
        super(plugin);
        this.module = module;
        this.settings = settings;
        this.timeAliases = new LinkedHashSet<TimeAlias>();
        ((Map)this.settings.timeAliases.get()).forEach((name, gameTime) -> this.timeAliases.add(new TimeAlias(LowerCase.INTERNAL.apply(name), (long)gameTime)));
    }

    @Override
    public void registerDefaults() {
        LinkedHashMap<String, String> rootChildrens = new LinkedHashMap<String, String>();
        rootChildrens.put(COMMAND_SHOW, COMMAND_SHOW);
        this.timeAliases.forEach(timeAlias -> {
            this.registerLiteral(timeAlias.name(), true, new String[]{timeAlias.name()}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_SET_TIME.text().formatted(String.valueOf(timeAlias.gameTime())))).permission(PERMISSION_SET)).withArguments(new ArgumentNodeBuilder[]{Arguments.world((String)"world").optional()}).executes((context, arguments) -> this.setWorldTime(context, arguments, timeAlias.gameTime())));
            rootChildrens.put(timeAlias.name(), timeAlias.name());
        });
        this.registerLiteral(COMMAND_SHOW, true, new String[]{"worldtime"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_SHOW.text())).permission(PERMISSION_SHOW)).withArguments(new ArgumentNodeBuilder[]{Arguments.world((String)"world").optional()}).executes(this::displayWorldTime));
        this.registerLiteral(COMMAND_SET, true, new String[]{"setworldtime"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_SET_TICKS)).permission(PERMISSION_SET)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"time", (int)0, (int)24000).localized(Lang.COMMAND_ARGUMENT_NAME_TIME).suggestions((reader, context) -> IntStream.range(0, 25).boxed().map(hour -> (long)hour.intValue() * 1000L).map(String::valueOf).toList()), Arguments.world((String)"world").optional()}).executes((context, arguments) -> this.setWorldTime(context, arguments, arguments.getInt("time"))));
        this.registerRoot("Time", true, new String[]{"time"}, rootChildrens, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERMISSION_ROOT));
    }

    private boolean setWorldTime(@NotNull CommandContext context, @NotNull ParsedArguments arguments, long ticks) {
        World world = this.getWorld(context, arguments, "world");
        if (world == null) {
            return false;
        }
        long worldTime = WorldTime.clamp(ticks);
        world.setTime(worldTime);
        LocalTime localTime = WorldTime.getTimeOfTicks(world.getTime());
        this.module.sendPrefixed(MESSAGE_SET_FEEDBACK, context.getSender(), replacer -> replacer.with("%world%", () -> BukkitThing.getValue((Keyed)world)).with("%time%", () -> SLUtils.formatTime(localTime)).with("%total%", () -> NumberUtil.format((double)worldTime)));
        return true;
    }

    private boolean displayWorldTime(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        World world = this.getWorld(context, arguments, "world");
        if (world == null) {
            return false;
        }
        long worldTicks = world.getTime();
        LocalTime worldTime = WorldTime.getTimeOfTicks(worldTicks);
        LocalTime serverTime = TimeUtil.getCurrentTime();
        Replacer replacer = Replacer.create().replace("%world%", (Object)BukkitThing.getValue((Keyed)world)).replace("%time%", (Object)SLUtils.formatTime(worldTime)).replace("%ticks%", (Object)NumberUtil.format((double)worldTicks)).replace("%global%", (Object)SLUtils.formatTime(serverTime));
        String text = String.join((CharSequence)"\n", replacer.apply((List)this.settings.timeDisplayFormat.get()));
        Players.sendMessage((CommandSender)context.getSender(), (String)text);
        return true;
    }
}

