/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.wrap.NightProfile;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.profile.CachedProfile;
import su.nightexpress.nightcore.util.profile.PlayerProfiles;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.utils.FutureUtils;

public class SkullCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("skull");
    private static final Permission PERMISSION_OTHERS = EssentialPerms.COMMAND.permission("skull.others");
    private static final Permission PERMISSION_CUSTOM = EssentialPerms.COMMAND.permission("skull.custom");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Skull.Custom.Desc").text("Get player's head.");
    private static final MessageLocale MESSAGE_GET_OWN_NOTIFY = LangEntry.builder((String)"Command.Skull.GetOwn").chatMessage(TagWrappers.GRAY.wrap("You have got a copy of your head."));
    private static final MessageLocale MESSAGE_GET_OTHERS_NOTIFY = LangEntry.builder((String)"Command.Skull.GetOther").chatMessage(TagWrappers.GRAY.wrap("You have got " + TagWrappers.SOFT_YELLOW.wrap("%player_name%") + "'s head."));
    private static final MessageLocale MESSAGE_GET_CUSTOM_NOTIFY = LangEntry.builder((String)"Command.Skull.GetCustom").chatMessage(TagWrappers.GRAY.wrap("You have got custom " + TagWrappers.SOFT_YELLOW.wrap("%player_name%") + " head."));
    private static final MessageLocale MESSAGE_INVALID_SKULL_DATA = LangEntry.builder((String)"Command.Skull.InvalidData").chatMessage(TagWrappers.SOFT_RED.wrap("Invalid skull data provided! You must provide either: " + TagWrappers.SOFT_YELLOW.wrap("Player name") + ", a " + TagWrappers.SOFT_YELLOW.wrap("URL") + " or " + TagWrappers.SOFT_YELLOW.wrap("Base 64") + " value."));
    private static final Pattern NAME_PATTERN = Pattern.compile("^[A-Za-z0-9_]+$");
    private static final Pattern URL_VALUE_PATTERN = Pattern.compile("^[0-9a-fA-F]{64}$");
    private static final Pattern BASE_64_PATTERN = Pattern.compile("^[A-Za-z0-9+/=]{180}$");
    private final EssentialModule module;

    public SkullCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("skull", true, new String[]{"skull", "playerhead", "customhead"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.string((String)"value").localized(Lang.COMMAND_ARGUMENT_NAME_OWNER).permission(PERMISSION_OTHERS)).optional()}).executes(this::createSkull));
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean createSkull(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        MessageLocale locale;
        NightProfile profile;
        Player player;
        block9: {
            block10: {
                player = context.getPlayerOrThrow();
                if (!arguments.contains("value")) break block10;
                String input = arguments.getString("value");
                if (BASE_64_PATTERN.matcher(input).matches()) {
                    if (!player.hasPermission(PERMISSION_CUSTOM)) {
                        context.errorBadPlayer();
                        return false;
                    }
                    String decoded = new String(Base64.getDecoder().decode(input));
                    JsonObject jsonObject = JsonParser.parseString((String)decoded).getAsJsonObject();
                    String url = Optional.ofNullable(jsonObject).flatMap(obj -> Optional.ofNullable(obj.getAsJsonObject("textures"))).flatMap(textures -> Optional.ofNullable(textures.getAsJsonObject("SKIN"))).flatMap(skin -> Optional.ofNullable(skin.get("url"))).map(JsonElement::getAsString).orElse(null);
                    if (url == null) {
                        context.send(MESSAGE_INVALID_SKULL_DATA);
                        return false;
                    }
                    input = url.substring(url.lastIndexOf("/") + 1);
                }
                if (URL_VALUE_PATTERN.matcher(input).matches()) {
                    if (!player.hasPermission(PERMISSION_CUSTOM)) {
                        context.errorBadPlayer();
                        return false;
                    }
                    profile = Optional.ofNullable(PlayerProfiles.createProfileBySkinURL((String)input)).map(CachedProfile::queryNoUpdate).orElse(null);
                    locale = MESSAGE_GET_CUSTOM_NOTIFY;
                    break block9;
                } else if (input.length() <= 16 && NAME_PATTERN.matcher(input).matches()) {
                    profile = Software.get().createProfile(null, input);
                    locale = MESSAGE_GET_OTHERS_NOTIFY;
                    break block9;
                } else {
                    context.send(MESSAGE_INVALID_SKULL_DATA);
                    return false;
                }
            }
            profile = PlayerProfiles.getProfile((OfflinePlayer)player).query();
            locale = MESSAGE_GET_OWN_NOTIFY;
        }
        if (profile == null) {
            return false;
        }
        ((CompletableFuture)profile.update().thenAcceptAsync(updated -> {
            ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
            ItemUtil.editMeta((ItemStack)itemStack, SkullMeta.class, arg_0 -> ((NightProfile)profile).apply(arg_0));
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{itemStack});
            this.module.sendPrefixed(locale, (CommandSender)player, builder -> builder.with("%player_name%", () -> String.valueOf(updated.getName())));
        }, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0))).whenComplete(FutureUtils::printStacktrace);
        return true;
    }
}

