/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.regex.TimedMatcher;
import su.nightexpress.nightcore.util.text.NightMessage;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.text.tag.TagPool;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserManager;

public class NickCommandsProvider
extends AbstractCommandProvider {
    private static final String COMMAND_CHANGE = "change";
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_SET = "set";
    private static final Permission NICK_ROOT = EssentialPerms.COMMAND.permission("nick.root");
    private static final Permission NICK_SET = EssentialPerms.COMMAND.permission("nick.set");
    public static final Permission NICK_CHANGE = EssentialPerms.COMMAND.permission("nick.change");
    private static final Permission NICK_CLEAR = EssentialPerms.COMMAND.permission("nick.clear");
    private static final Permission NICK_CLEAR_OTHERS = EssentialPerms.COMMAND.permission("nick.clear.others");
    private static final Permission NICK_COLORS = EssentialPerms.COMMAND.permission("nick.colors");
    private static final Permission NICK_BYPASS_WORDS = EssentialPerms.COMMAND.permission("nick.bypass.words");
    private static final Permission NICK_BYPASS_REGEX = EssentialPerms.COMMAND.permission("nick.bypass.regex");
    private static final Permission NICK_BYPASS_LENGTH = EssentialPerms.COMMAND.permission("nick.bypass.length");
    private static final TextLocale COMMAND_NICK_ROOT_DESC = LangEntry.builder((String)"Command.Nick.Root.Desc").text("Nick commands.");
    private static final TextLocale COMMAND_NICK_CLEAR_DESC = LangEntry.builder((String)"Command.Nick.Clear.Desc").text("Remove custom name.");
    private static final TextLocale COMMAND_NICK_SET_DESC = LangEntry.builder((String)"Command.Nick.Set.Desc").text("Set player's custom name.");
    private static final TextLocale COMMAND_NICK_CHANGE_DESC = LangEntry.builder((String)"Command.Nick.Change.Desc").text("Set custom name.");
    private static final MessageLocale COMMAND_NICK_CLEAR_TARGET = LangEntry.builder((String)"Command.Nick.Clear.Target").chatMessage(TagWrappers.GRAY.wrap("Removed " + TagWrappers.SOFT_YELLOW.wrap("%player_display_name%") + "'s custom name."));
    private static final MessageLocale COMMAND_NICK_CLEAR_NOTIFY = LangEntry.builder((String)"Command.Nick.Clear.Notify").chatMessage(TagWrappers.GRAY.wrap("You custom name has been removed."));
    private static final MessageLocale COMMAND_NICK_SET_TARGET = LangEntry.builder((String)"Command.Nick.Set.Target").chatMessage(TagWrappers.GRAY.wrap("Set " + TagWrappers.SOFT_YELLOW.wrap("%player_name%") + "'s custom name to " + TagWrappers.SOFT_YELLOW.wrap("%name%") + "."));
    private static final MessageLocale COMMAND_NICK_SET_NOTIFY = LangEntry.builder((String)"Command.Nick.Set.Notify").chatMessage(TagWrappers.GRAY.wrap("You got a new custom name: " + TagWrappers.SOFT_YELLOW.wrap("%name%") + "."));
    private static final MessageLocale COMMAND_NICK_CHANGE_DONE = LangEntry.builder((String)"Command.Nick.Change.Done").chatMessage(TagWrappers.GRAY.wrap("You changed your custom name to " + TagWrappers.SOFT_YELLOW.wrap("%name%") + "."));
    private static final MessageLocale COMMAND_NICK_CHANGE_ERROR_BAD_WORDS = LangEntry.builder((String)"Command.Nick.Error.BadWords").chatMessage(TagWrappers.SOFT_RED.wrap("This name is not allowed."));
    private static final MessageLocale COMMAND_NICK_CHANGE_ERROR_REGEX = LangEntry.builder((String)"Command.Nick.Error.Regex").chatMessage(TagWrappers.SOFT_RED.wrap("Name contains forbidden characters."));
    private static final MessageLocale COMMAND_NICK_CHANGE_ERROR_TOO_LONG = LangEntry.builder((String)"Command.Nick.Error.TooLong").chatMessage(TagWrappers.GRAY.wrap("Name can't be no longer than " + TagWrappers.SOFT_RED.wrap("%amount%") + " characters."));
    private static final MessageLocale COMMAND_NICK_CHANGE_ERROR_TOO_SHORT = LangEntry.builder((String)"Command.Nick.Error.TooShort").chatMessage(TagWrappers.SOFT_RED.wrap("Name can't be shorted than " + TagWrappers.SOFT_RED.wrap("%amount%") + " characters."));
    private final EssentialModule module;
    private final EssentialSettings settings;
    private final UserManager userManager;
    private final Pattern nickPattern;

    public NickCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull EssentialSettings settings, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.settings = settings;
        this.userManager = userManager;
        this.nickPattern = Pattern.compile((String)this.settings.nickRegex.get());
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_CHANGE, true, new String[]{"changenick"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(COMMAND_NICK_CHANGE_DESC)).permission(NICK_CHANGE)).withArguments(new ArgumentNodeBuilder[]{Arguments.greedyString((String)"name").localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME)}).executes(this::changeNick));
        this.registerLiteral(COMMAND_CLEAR, true, new String[]{"clearnick"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(COMMAND_NICK_CLEAR_DESC)).permission(NICK_CLEAR)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").optional().permission(NICK_CLEAR_OTHERS)}).withFlags(new String[]{"s"}).executes(this::clearNick));
        this.registerLiteral(COMMAND_SET, true, new String[]{"setnick"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(COMMAND_NICK_SET_DESC)).permission(NICK_SET)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), Arguments.greedyString((String)"name").localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME)}).withFlags(new String[]{"s"}).executes(this::setNickForPlayer));
        this.registerRoot("nickname", true, new String[]{"nickname"}, Map.of(COMMAND_CHANGE, COMMAND_CHANGE, COMMAND_CLEAR, COMMAND_CLEAR, COMMAND_SET, COMMAND_SET), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(COMMAND_NICK_ROOT_DESC)).permission(NICK_ROOT));
    }

    @NotNull
    private static String filterColors(@NotNull String name) {
        return NightMessage.stripTags((String)name, (TagPool)TagPool.ALL_COLORS_AND_STYLES);
    }

    private boolean changeNick(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        String nick = arguments.getString("name");
        String raw = NightMessage.stripTags((String)nick);
        if (!player.hasPermission(NICK_BYPASS_LENGTH)) {
            if (raw.length() < (Integer)this.settings.nickMinLength.get()) {
                this.module.sendPrefixed(COMMAND_NICK_CHANGE_ERROR_TOO_SHORT, context.getSender(), replacer -> replacer.with("%amount%", () -> String.valueOf(this.settings.nickMinLength.get())));
                return false;
            }
            if (raw.length() > (Integer)this.settings.nickMaxLength.get()) {
                this.module.sendPrefixed(COMMAND_NICK_CHANGE_ERROR_TOO_LONG, context.getSender(), replacer -> replacer.with("%amount%", () -> String.valueOf(this.settings.nickMaxLength.get())));
                return false;
            }
        }
        if (!player.hasPermission(NICK_BYPASS_WORDS)) {
            if (((Set)this.settings.nickBannedWords.get()).stream().anyMatch(word -> raw.toLowerCase().contains(word.toLowerCase()))) {
                this.module.sendPrefixed(COMMAND_NICK_CHANGE_ERROR_BAD_WORDS, context.getSender());
                return false;
            }
            if (this.plugin.getServer().getPlayerExact(raw) != null) {
                this.module.sendPrefixed(COMMAND_NICK_CHANGE_ERROR_BAD_WORDS, context.getSender());
                return false;
            }
        }
        if (!player.hasPermission(NICK_BYPASS_REGEX) && !TimedMatcher.create((Pattern)this.nickPattern, (String)raw).matches()) {
            this.module.sendPrefixed(COMMAND_NICK_CHANGE_ERROR_REGEX, context.getSender());
            return false;
        }
        nick = player.hasPermission(NICK_COLORS) ? NickCommandsProvider.filterColors(nick) : raw;
        SunUser user = (SunUser)this.plugin.getUserManager().getOrFetch(player);
        this.module.setCustomName(user, nick);
        String finalNick = nick;
        this.module.sendPrefixed(COMMAND_NICK_CHANGE_DONE, context.getSender(), replacer -> replacer.with("%name%", () -> finalNick));
        return true;
    }

    private boolean clearNick(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderWithDataAndRunInMainThread(context, arguments, this.module, this.userManager, (user, target) -> {
            this.module.setCustomName((SunUser)((Object)user), null);
            EntityUtil.setCustomName((Entity)target, (NightComponent)null);
            if (context.getSender() != target) {
                this.module.sendPrefixed(COMMAND_NICK_CLEAR_TARGET, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(COMMAND_NICK_CLEAR_NOTIFY, (CommandSender)target);
            }
        });
    }

    private boolean setNickForPlayer(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerWithDataAndRunInMainThread(context, arguments, this.module, this.userManager, (user, target) -> {
            String nick = arguments.getString("name");
            String raw = NightMessage.stripAll((String)nick);
            nick = context.hasPermission(NICK_COLORS) ? NickCommandsProvider.filterColors(nick) : raw;
            this.module.setCustomName((SunUser)((Object)user), nick);
            if (context.getSender() != user.player().orElse(null)) {
                String finalNick1 = nick;
                this.module.sendPrefixed(COMMAND_NICK_SET_TARGET, context.getSender(), replacer -> replacer.with("%name%", () -> finalNick1).with("%player_name%", () -> ((SunUser)((Object)user)).getName()));
            }
            if (!context.hasFlag("s")) {
                String finalNick = nick;
                this.module.sendPrefixed(COMMAND_NICK_SET_NOTIFY, (CommandSender)target, replacer -> replacer.with("%name%", () -> finalNick));
            }
        });
    }
}

