/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialLang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.user.UserManager;

public class InvulnerabilityCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_TOGGLE = "toggle";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_OFF = "off";
    private final EssentialModule module;
    private final EssentialSettings settings;
    private final UserManager userManager;

    public InvulnerabilityCommandProvider(@NonNull SunLightPlugin plugin, @NonNull EssentialModule module, @NonNull EssentialSettings settings, @NonNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.settings = settings;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_TOGGLE, true, new String[]{"invulnerability", "god"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.TOGGLE));
        this.registerLiteral(COMMAND_ON, false, new String[]{"invulnerability-on", "god-on"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.ON));
        this.registerLiteral(COMMAND_OFF, false, new String[]{"invulnerability-off", "god-off"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.OFF));
    }

    private void buildCommand(@NonNull LiteralNodeBuilder builder, @NonNull ToggleMode mode) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(EssentialLang.COMMAND_INVULNERABILITY_DESC)).permission(EssentialPerms.COMMAND_INVULNERABILITY)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(EssentialPerms.COMMAND_INVULNERABILITY_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleInvulnerability(context, arguments, mode));
    }

    private boolean toggleInvulnerability(@NonNull CommandContext context, @NonNull ParsedArguments arguments, @NonNull ToggleMode mode) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            boolean isYourself;
            boolean toState = mode.apply(target.isInvulnerable());
            boolean bl = isYourself = context.getSender() == target;
            if (isYourself && !target.hasPermission(EssentialPerms.BYPASS_INVULNERABILITY_WORLD) && toState && !this.settings.isInvulnerabilityAllowedInThisWorld(target.getWorld())) {
                this.module.sendPrefixed(EssentialLang.INVULNERABILITY_RESTRICTED_WORLD_USAGE, context.getSender());
                return;
            }
            target.setInvulnerable(toState);
            if (!isYourself) {
                this.module.sendPrefixed(EssentialLang.INVULNERABILITY_TOGGLE_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)).with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(toState)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(EssentialLang.INVULNERABILITY_TOGGLE_NOTIFY, (CommandSender)target, builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(toState)));
            }
        });
    }
}

