/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Map;
import java.util.stream.IntStream;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ModifyMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.user.UserManager;

public class HealthCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_RESTORE = "restore";
    private static final String COMMAND_ADD = "add";
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_REMOVE = "remove";
    private static final Permission PERM_ADD = EssentialPerms.COMMAND.permission("health.add");
    private static final Permission PERM_SET = EssentialPerms.COMMAND.permission("health.set");
    private static final Permission PERM_REMOVE = EssentialPerms.COMMAND.permission("health.remove");
    private static final Permission PERM_RESTORE = EssentialPerms.COMMAND.permission("health.restore");
    private static final Permission PERM_ROOT = EssentialPerms.COMMAND.permission("health.root");
    private static final Permission PERM_OTHERS = EssentialPerms.COMMAND.permission("health.others");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Health.Root.Desc").text("Health commands.");
    private static final TextLocale DESCRIPTION_ADD = LangEntry.builder((String)"Command.Health.Add.Desc").text("Add health points.");
    private static final TextLocale DESCRIPTION_SET = LangEntry.builder((String)"Command.Health.Set.Desc").text("Set health points.");
    private static final TextLocale DESCRIPTION_REMOVE = LangEntry.builder((String)"Command.Health.Remove.Desc").text("Remove health points.");
    private static final TextLocale DESCRIPTION_RESTORE = LangEntry.builder((String)"Command.Health.Restore.Desc").text("Restore player's health or revive.");
    private static final MessageLocale MESSAGE_ADD_FEEDBACK = LangEntry.builder((String)"Command.Health.Add.Target").chatMessage(Sound.ENTITY_WITCH_DRINK, new String[]{TagWrappers.GRAY.wrap("You have " + TagWrappers.GREEN.wrap("healed") + " " + TagWrappers.WHITE.wrap("%player_display_name%") + " for " + TagWrappers.GREEN.wrap("%amount%\u2764") + " (" + TagWrappers.WHITE.wrap("%oldvalue%\u2764") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%\u2764") + ")")});
    private static final MessageLocale MESSAGE_REMOVE_FEEDBACK = LangEntry.builder((String)"Command.Health.Remove.Target").chatMessage(Sound.ENTITY_PLAYER_HURT, new String[]{TagWrappers.GRAY.wrap("You have " + TagWrappers.RED.wrap("damaged") + " " + TagWrappers.WHITE.wrap("%player_display_name%") + " for " + TagWrappers.RED.wrap("%amount%\u2764") + " (" + TagWrappers.WHITE.wrap("%oldvalue%\u2764") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.RED.wrap("%newvalue%\u2764") + ")")});
    private static final MessageLocale MESSAGE_SET_FEEDBACK = LangEntry.builder((String)"Command.Health.Set.Target").chatMessage(Sound.ENTITY_WITCH_DRINK, new String[]{TagWrappers.GRAY.wrap("You have " + TagWrappers.YELLOW.wrap("set") + " " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s health to " + TagWrappers.YELLOW.wrap("%amount%\u2764") + " (" + TagWrappers.WHITE.wrap("%oldvalue%\u2764") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.RED.wrap("%newvalue%\u2764") + ")")});
    private static final MessageLocale MESSAGE_ADD_NOTIFY = LangEntry.builder((String)"Command.Health.Add.Notify").chatMessage(Sound.ENTITY_WITCH_DRINK, new String[]{TagWrappers.GRAY.wrap("You have been " + TagWrappers.GREEN.wrap("healed") + " for " + TagWrappers.GREEN.wrap("%amount%\u2764") + ".")});
    private static final MessageLocale MESSAGE_REMOVE_NOTIFY = LangEntry.builder((String)"Command.Health.Remove.Notify").chatMessage(Sound.ENTITY_PLAYER_HURT, new String[]{TagWrappers.GRAY.wrap("You have been " + TagWrappers.RED.wrap("damaged") + " for " + TagWrappers.RED.wrap("%amount%\u2764") + ".")});
    private static final MessageLocale MESSAGE_SET_NOTIFY = LangEntry.builder((String)"Command.Health.Set.Notify").chatMessage(Sound.ENTITY_WITCH_DRINK, new String[]{TagWrappers.GRAY.wrap("Your health has been set to " + TagWrappers.YELLOW.wrap("%amount%\u2764") + ".")});
    private static final MessageLocale MESSAGE_RESTORE_NOTIFY = LangEntry.builder((String)"Command.Health.Restore.Notfiy").chatMessage(Sound.ENTITY_WITCH_DRINK, new String[]{TagWrappers.GRAY.wrap("You have been fully healed.")});
    private static final MessageLocale MESSAGE_RESTORE_FEEDBACK = LangEntry.builder((String)"Command.Health.Restore.Info").chatMessage(Sound.ENTITY_WITCH_DRINK, new String[]{TagWrappers.GRAY.wrap("You have restored " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s health.")});
    private static final MessageLocale MESSAGE_REVIVE_NOTIFY = LangEntry.builder((String)"Command.Health.Revive.Feedback").chatMessage(Sound.ITEM_TOTEM_USE, new String[]{TagWrappers.GRAY.wrap("You have been revived.")});
    private static final MessageLocale MESSAGE_REVIVE_FEEDBACK = LangEntry.builder((String)"Command.Health.Revive.Notify").chatMessage(Sound.ITEM_TOTEM_USE, new String[]{TagWrappers.GRAY.wrap("You have revived " + TagWrappers.WHITE.wrap("%player_display_name%") + ".")});
    private static final MessageLocale MESSAGE_DEAD_FEEDBACK = LangEntry.builder((String)"Command.Health.TargetDead.Feedback").chatMessage(Sound.ENTITY_VILLAGER_NO, new String[]{TagWrappers.GRAY.wrap(TagWrappers.WHITE.wrap("%player_display_name%") + "'s health can not modified, because they are dead.")});
    private static final MessageLocale MESSAGE_DEAD_NOTIFY = LangEntry.builder((String)"Command.Health.TargetDead.Notify").chatMessage(Sound.ENTITY_VILLAGER_NO, new String[]{TagWrappers.GRAY.wrap("You can't change your health while you are dead.")});
    private final EssentialModule module;
    private final EssentialSettings settings;
    private final UserManager userManager;

    public HealthCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull EssentialSettings settings, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.settings = settings;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_ADD, false, new String[]{"addhealth"}, builder -> this.builderMode((LiteralNodeBuilder)builder, ModifyMode.ADD));
        this.registerLiteral(COMMAND_SET, false, new String[]{"sethealth"}, builder -> this.builderMode((LiteralNodeBuilder)builder, ModifyMode.SET));
        this.registerLiteral(COMMAND_REMOVE, false, new String[]{"removehealth"}, builder -> this.builderMode((LiteralNodeBuilder)builder, ModifyMode.REMOVE));
        this.registerLiteral(COMMAND_RESTORE, true, new String[]{"heal"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_RESTORE)).permission(PERM_RESTORE)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERM_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::restoreHealth));
        this.registerRoot("Health", true, new String[]{"health", "hp"}, Map.of(COMMAND_ADD, COMMAND_ADD, COMMAND_SET, COMMAND_SET, COMMAND_REMOVE, COMMAND_REMOVE, COMMAND_RESTORE, COMMAND_RESTORE), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERM_ROOT));
    }

    private void builderMode(@NotNull LiteralNodeBuilder builder, @NotNull ModifyMode mode) {
        TextLocale description = switch (mode) {
            default -> throw new MatchException(null, null);
            case ModifyMode.ADD -> DESCRIPTION_ADD;
            case ModifyMode.SET -> DESCRIPTION_SET;
            case ModifyMode.REMOVE -> DESCRIPTION_REMOVE;
        };
        Permission permission = switch (mode) {
            default -> throw new MatchException(null, null);
            case ModifyMode.ADD -> PERM_ADD;
            case ModifyMode.SET -> PERM_SET;
            case ModifyMode.REMOVE -> PERM_REMOVE;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(permission)).withArguments(new ArgumentNodeBuilder[]{Arguments.decimal((String)"amount", (double)0.0).localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT.text()).suggestions((reader, tabContext) -> IntStream.range(0, 21).boxed().map(String::valueOf).toList()), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERM_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.changeHealth(context, arguments, mode));
    }

    private boolean changeHealth(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ModifyMode mode) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            MessageLocale notifyMessage;
            if (target.isDead()) {
                context.send(context.getSender() == target ? MESSAGE_DEAD_NOTIFY : MESSAGE_DEAD_FEEDBACK, replacer -> replacer.replace(SLPlaceholders.forPlayer((Player)target)));
                return;
            }
            double amount = arguments.getDouble("amount");
            double oldHealth = target.getHealth();
            double maxHealth = EntityUtil.getAttributeValue((LivingEntity)target, (Attribute)Attribute.MAX_HEALTH);
            double newHealth = Math.clamp(mode.modify(oldHealth, amount), 0.0, maxHealth);
            if (newHealth < oldHealth) {
                target.sendHurtAnimation(0.0f);
            }
            target.setHealth(newHealth);
            MessageLocale feedbackMessage = switch (mode) {
                default -> throw new MatchException(null, null);
                case ModifyMode.SET -> MESSAGE_SET_FEEDBACK;
                case ModifyMode.REMOVE -> MESSAGE_REMOVE_FEEDBACK;
                case ModifyMode.ADD -> MESSAGE_ADD_FEEDBACK;
            };
            switch (mode) {
                default: {
                    throw new MatchException(null, null);
                }
                case ADD: {
                    MessageLocale messageLocale = MESSAGE_ADD_NOTIFY;
                    break;
                }
                case SET: {
                    MessageLocale messageLocale = MESSAGE_SET_NOTIFY;
                    break;
                }
                case REMOVE: {
                    MessageLocale messageLocale = notifyMessage = MESSAGE_REMOVE_NOTIFY;
                }
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(feedbackMessage, context.getSender(), builder -> builder.with("%oldvalue%", () -> NumberUtil.format((double)oldHealth)).with("%newvalue%", () -> NumberUtil.format((double)target.getHealth())).with("%amount%", () -> NumberUtil.format((double)amount)).with("%current%", () -> NumberUtil.format((double)target.getHealth())).with("%max%", () -> NumberUtil.format((double)maxHealth)).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(notifyMessage, (CommandSender)target, builder -> builder.with("%oldvalue%", () -> NumberUtil.format((double)oldHealth)).with("%newvalue%", () -> NumberUtil.format((double)target.getHealth())).with("%amount%", () -> NumberUtil.format((double)amount)).with("%current%", () -> NumberUtil.format((double)target.getHealth())).with("%max%", () -> NumberUtil.format((double)maxHealth)));
            }
        });
    }

    private boolean restoreHealth(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            MessageLocale notifyLocale;
            MessageLocale feedbackLocale;
            if (target.isDead()) {
                feedbackLocale = MESSAGE_REVIVE_FEEDBACK;
                notifyLocale = MESSAGE_REVIVE_NOTIFY;
                target.spigot().respawn();
            } else {
                feedbackLocale = MESSAGE_RESTORE_FEEDBACK;
                notifyLocale = MESSAGE_RESTORE_NOTIFY;
                double maxHealth = EntityUtil.getAttributeValue((LivingEntity)target, (Attribute)Attribute.MAX_HEALTH);
                target.setHealth(maxHealth);
                if (((Boolean)this.settings.healthClearEffects.get()).booleanValue()) {
                    target.getActivePotionEffects().forEach(effect -> target.removePotionEffect(effect.getType()));
                }
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(feedbackLocale, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(notifyLocale, (CommandSender)target);
            }
        });
    }
}

