/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.nms.SunNMS;
import su.nightexpress.sunlight.user.UserManager;

public class GamemodeCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_SURVIVAL = "survival";
    private static final String COMMAND_SPECTATOR = "spectator";
    private static final String COMMAND_ADVENTURE = "adventure";
    private static final String COMMAND_CREATIVE = "creative";
    private static final Permission PERM_SURVIVAL = EssentialPerms.COMMAND.permission("gamemode.survival");
    private static final Permission PERM_SPECTATOR = EssentialPerms.COMMAND.permission("gamemode.spectator");
    private static final Permission PERM_ADVENTURE = EssentialPerms.COMMAND.permission("gamemode.adventure");
    private static final Permission PERM_CREATIVE = EssentialPerms.COMMAND.permission("gamemode.creative");
    private static final Permission PERM_OTEHRS = EssentialPerms.COMMAND.permission("gamemode.others");
    private static final Permission PERM_ROOT = EssentialPerms.COMMAND.permission("gamemode.root");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.GameMode.Root.Desc").text("Game Mode commands.");
    private static final TextLocale DESCRIPTION_TYPE = LangEntry.builder((String)"Command.GameMode.Type.Desc").text("Set Game Mode to %type%.");
    private static final MessageLocale MESSAGE_SET_NOTIFY = LangEntry.builder((String)"Command.GameMode.Notify").chatMessage(TagWrappers.GRAY.wrap("Your Game Mode has been set to " + TagWrappers.SOFT_YELLOW.wrap("%type%") + "."));
    private static final MessageLocale MESSAGE_SET_FEEDBACK = LangEntry.builder((String)"Command.GameMode.Target").chatMessage(TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s Game Mode to " + TagWrappers.SOFT_YELLOW.wrap("%type%") + "."));
    private final EssentialModule module;
    private final UserManager userManager;

    public GamemodeCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_SURVIVAL, true, new String[]{"gms", COMMAND_SURVIVAL}, builder -> this.builderType((LiteralNodeBuilder)builder, GameMode.SURVIVAL));
        this.registerLiteral(COMMAND_SPECTATOR, true, new String[]{"gmsp", COMMAND_SPECTATOR}, builder -> this.builderType((LiteralNodeBuilder)builder, GameMode.SPECTATOR));
        this.registerLiteral(COMMAND_ADVENTURE, true, new String[]{"gma", COMMAND_ADVENTURE}, builder -> this.builderType((LiteralNodeBuilder)builder, GameMode.ADVENTURE));
        this.registerLiteral(COMMAND_CREATIVE, true, new String[]{"gmc", COMMAND_CREATIVE}, builder -> this.builderType((LiteralNodeBuilder)builder, GameMode.CREATIVE));
        this.registerRoot("Game Mode", true, new String[]{"gm", "gamemode"}, Map.of(COMMAND_SURVIVAL, COMMAND_SURVIVAL, COMMAND_SPECTATOR, COMMAND_SPECTATOR, COMMAND_ADVENTURE, COMMAND_ADVENTURE, COMMAND_CREATIVE, COMMAND_CREATIVE), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERM_ROOT));
    }

    private void builderType(@NotNull LiteralNodeBuilder builder, @NotNull GameMode mode) {
        Permission permission = switch (mode) {
            default -> throw new MatchException(null, null);
            case GameMode.CREATIVE -> PERM_CREATIVE;
            case GameMode.SURVIVAL -> PERM_SURVIVAL;
            case GameMode.ADVENTURE -> PERM_ADVENTURE;
            case GameMode.SPECTATOR -> PERM_SPECTATOR;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_TYPE.text().replace("%type%", Lang.GAME_MODE.getLocalized((Enum)mode)))).permission(permission)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERM_OTEHRS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.changeGameMode(context, arguments, mode));
    }

    private boolean changeGameMode(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull GameMode mode) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            if (target.isOnline()) {
                target.setGameMode(mode);
            } else {
                SunNMS internals = this.plugin.getInternals();
                if (internals == null) {
                    this.module.sendPrefixed(Lang.ERROR_NO_INTERNALS_HANDLER, context.getSender());
                    return;
                }
                internals.setGameMode((Player)target, mode);
            }
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_SET_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)).with("%type%", () -> Lang.GAME_MODE.getLocalized((Enum)mode)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_SET_NOTIFY, (CommandSender)target, builder -> builder.with("%type%", () -> Lang.GAME_MODE.getLocalized((Enum)mode)));
            }
        });
    }
}

