/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;

public class ForceRunCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("forcerun");
    private static final Permission PERMISSION_BYPASS = EssentialPerms.COMMAND.permission("forcerun.bypass");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.ForceRun.Description").text("Force player to execute a command.");
    private static final MessageLocale MESSAGE_FORCED_FEEDBACK = LangEntry.builder((String)"Command.ForceRun.Forced.Feedback").chatMessage(TagWrappers.GRAY.wrap("You have forced " + TagWrappers.WHITE.wrap("%player_display_name%") + " to execute: " + TagWrappers.SOFT_YELLOW.wrap("%command%")));
    private static final MessageLocale MESSAGE_IMMUNITY = LangEntry.builder((String)"Command.ForceRun.Immunity").chatMessage(TagWrappers.GRAY.wrap("Player " + TagWrappers.WHITE.wrap("%player_display_name%") + " is immune to this command."));
    private final EssentialModule module;

    public ForceRunCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("forcerun", true, new String[]{"forcerun"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{Arguments.player((String)"player"), Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_COMMAND)}).executes(this::forceRun));
    }

    private boolean forceRun(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player target = arguments.getPlayer("player");
        if (context.getSender() == target) {
            this.module.sendPrefixed(CoreLang.COMMAND_EXECUTION_NOT_YOURSELF, context.getSender());
            return false;
        }
        if (context.getSender() instanceof Player && target.hasPermission(PERMISSION_BYPASS)) {
            this.module.sendPrefixed(MESSAGE_IMMUNITY, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
            return false;
        }
        String commandToRun = arguments.getString("text");
        target.performCommand(commandToRun);
        this.module.sendPrefixed(MESSAGE_FORCED_FEEDBACK, context.getSender(), replacer -> replacer.with("%command%", () -> commandToRun).with(CommonPlaceholders.PLAYER.resolver((Object)target)));
        return true;
    }
}

