/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.user.UserManager;

public class FireTicksCommandsProvider
extends AbstractCommandProvider {
    private static final String COMMAND_IGNITE = "ignite";
    private static final String COMMAND_EXTINGUISH = "extinguish";
    private static final Permission PERMISSION_IGNITE = EssentialPerms.COMMAND.permission("ignite");
    private static final Permission PERMISSION_EXTINGUISH = EssentialPerms.COMMAND.permission("extinguish");
    private static final Permission PERMISSION_EXTINGUISH_OTHERS = EssentialPerms.COMMAND.permission("extinguish.others");
    private static final TextLocale DESCRIPTION_IGNITE = LangEntry.builder((String)"Command.Ignite.Desc").text("Ignite a player.");
    private static final TextLocale DESCRIPTION_EXTINGUISH = LangEntry.builder((String)"Command.Extinguish.Desc").text("Extinguish a player.");
    private static final MessageLocale MESSAGE_EXTINGUISH_FEEDBACK = LangEntry.builder((String)"Command.Extinguish.Feedback").chatMessage(Sound.BLOCK_FIRE_EXTINGUISH, new String[]{TagWrappers.GRAY.wrap("You have extinguished " + TagWrappers.WHITE.wrap("%player_display_name%") + ".")});
    private static final MessageLocale MESSAGE_EXTINGUISH_NOTIFY = LangEntry.builder((String)"Command.Extinguish.Notify").chatMessage(Sound.BLOCK_FIRE_EXTINGUISH, new String[]{TagWrappers.GRAY.wrap("You have been extinguished.")});
    private static final MessageLocale MESSAGE_IGNITE_FEEDBACK = LangEntry.builder((String)"Command.Ignite.Feedback").chatMessage(Sound.ENTITY_PLAYER_HURT_ON_FIRE, new String[]{TagWrappers.GRAY.wrap("You have ignited " + TagWrappers.WHITE.wrap("%player_display_name%") + " for " + TagWrappers.SOFT_YELLOW.wrap("%time%"))});
    private static final MessageLocale MESSAGE_IGNITE_NOTIFY = LangEntry.builder((String)"Command.Ignite.Notify").chatMessage(Sound.ENTITY_PLAYER_HURT_ON_FIRE, new String[]{TagWrappers.GRAY.wrap("You have been ignited for " + TagWrappers.SOFT_RED.wrap("%time%"))});
    private final EssentialModule module;
    private final UserManager userManager;

    public FireTicksCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_IGNITE, true, new String[]{COMMAND_IGNITE}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_IGNITE)).permission(PERMISSION_IGNITE)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), Arguments.integer((String)"time", (int)1, (int)86400).localized(Lang.COMMAND_ARGUMENT_NAME_TIME.text()).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"5", "10", "30", "60"}))}).withFlags(new String[]{"s"}).executes(this::ignite));
        this.registerLiteral(COMMAND_EXTINGUISH, true, new String[]{COMMAND_EXTINGUISH}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_EXTINGUISH)).permission(PERMISSION_EXTINGUISH)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_EXTINGUISH_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::extinguish));
    }

    private boolean ignite(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            int seconds = arguments.getInt("time");
            long ticks = TimeUtil.secondsToTicks((int)seconds);
            target.setFireTicks((int)ticks);
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_IGNITE_FEEDBACK, context.getSender(), builder -> builder.with("%time%", () -> TimeFormats.toLiteral((long)((long)seconds * 1000L))).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_IGNITE_NOTIFY, (CommandSender)target, builder -> builder.with("%time%", () -> TimeFormats.toLiteral((long)((long)seconds * 1000L))));
            }
        });
    }

    private boolean extinguish(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            target.setFireTicks(0);
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_EXTINGUISH_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_EXTINGUISH_NOTIFY, (CommandSender)target);
            }
        });
    }
}

