/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandArguments;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.user.UserManager;

public class EnchantCommandsProvider
extends AbstractCommandProvider {
    private static final String ARG_SLOT = "slot";
    private static final String ARG_ENCHANT = "enchant";
    private static final String ARG_LEVEL = "level";
    private static final Permission PERMISSION_ENCHANT = EssentialPerms.COMMAND.permission("enchant");
    private static final Permission PERMISSION_DISENCHANT = EssentialPerms.COMMAND.permission("disenchant");
    private static final TextLocale DESCRIPTION_ENCHANT = LangEntry.builder((String)"Command.Enchant.Desc").text("Enchant item in a slot.");
    private static final TextLocale DESCRIPTION_DISENCHANT = LangEntry.builder((String)"Command.Disenchant.Desc").text("Disenchant item in a slot.");
    private static final MessageLocale MESSAGE_ERROR_NO_ITEM = LangEntry.builder((String)"Command.Enchant.EmptySlot").chatMessage(TagWrappers.GRAY.wrap("There is no item in the " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.SOFT_RED.wrap("%slot%") + " slot."));
    private static final MessageLocale MESSAGE_ERROR_NO_ENCHANT = LangEntry.builder((String)"Command.Disenchant.NotEnchanted").chatMessage(TagWrappers.GRAY.wrap("The " + TagWrappers.SOFT_RED.wrap("%item%") + " item in the " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.SOFT_RED.wrap("%slot%") + " slot does not contain " + TagWrappers.SOFT_RED.wrap("%enchantment%") + " enchantment to remove."));
    private static final MessageLocale MESSAGE_ENCHANTED_FEEDBACK = LangEntry.builder((String)"Command.Enchant.Enchanted.Target").chatMessage(Sound.BLOCK_ENCHANTMENT_TABLE_USE, new String[]{TagWrappers.GRAY.wrap("You have enchanted " + TagWrappers.WHITE.wrap("%item%") + " with " + TagWrappers.ORANGE.wrap("%name% %amount%") + " in " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.WHITE.wrap("%type%") + " slot.")});
    private static final MessageLocale MESSAGE_ENCHANTED_NOTIFY = LangEntry.builder((String)"Command.Enchant.Enchanted.Notify").chatMessage(Sound.BLOCK_ENCHANTMENT_TABLE_USE, new String[]{TagWrappers.GRAY.wrap("Your " + TagWrappers.WHITE.wrap("%item%") + " has been enchanted with " + TagWrappers.ORANGE.wrap("%name% %amount%") + ".")});
    private static final MessageLocale MESSAGE_DISENCHANTED_SPECIFIC_FEEDBACK = LangEntry.builder((String)"Command.Disenchant.Specific.Target").chatMessage(Sound.BLOCK_GRINDSTONE_USE, new String[]{TagWrappers.GRAY.wrap("You have removed " + TagWrappers.ORANGE.wrap("%enchantment%") + " from " + TagWrappers.WHITE.wrap("%item%") + " in " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.WHITE.wrap("%type%") + " slot.")});
    private static final MessageLocale MESSAGE_DISENCHANTED_SPECIFIC_NOTIFY = LangEntry.builder((String)"Command.Disenchant.Specific.Notify").chatMessage(Sound.BLOCK_GRINDSTONE_USE, new String[]{TagWrappers.GRAY.wrap("Your " + TagWrappers.WHITE.wrap("%item%") + " has been disenchanted from " + TagWrappers.ORANGE.wrap("%enchantment%") + ".")});
    private static final MessageLocale MESSAGE_DISENCHANTED_ALL_FEEDBACK = LangEntry.builder((String)"Command.Disenchant.All.Target").chatMessage(Sound.BLOCK_GRINDSTONE_USE, new String[]{TagWrappers.GRAY.wrap("You have disenchanted " + TagWrappers.WHITE.wrap("%item%") + " in " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s " + TagWrappers.WHITE.wrap("%type%") + " slot.")});
    private static final MessageLocale MESSAGE_DISENCHANTED_ALL_NOTIFY = LangEntry.builder((String)"Command.Disenchant.All.Notify").chatMessage(Sound.BLOCK_GRINDSTONE_USE, new String[]{TagWrappers.GRAY.wrap("Your " + TagWrappers.WHITE.wrap("%item%") + " has been disenchanted.")});
    private final EssentialModule module;
    private final UserManager userManager;

    public EnchantCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(ARG_ENCHANT, true, new String[]{ARG_ENCHANT}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_ENCHANT)).permission(PERMISSION_ENCHANT)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_ENCHANT), CommandArguments.slot(ARG_SLOT), Arguments.enchantment((String)ARG_ENCHANT), Arguments.integer((String)ARG_LEVEL, (int)1).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"0", "1", "5", "10", "127"})).optional()}).withFlags(new String[]{"s"}).executes(this::enchantSlot));
        this.registerLiteral("disenchant", true, new String[]{"disenchant"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_DISENCHANT)).permission(PERMISSION_DISENCHANT)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), CommandArguments.slot(ARG_SLOT), Arguments.enchantment((String)ARG_ENCHANT).optional()}).withFlags(new String[]{"s"}).executes(this::disenchantSlot));
    }

    private boolean enchantSlot(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            EquipmentSlot slot = (EquipmentSlot)arguments.get(ARG_SLOT, EquipmentSlot.class);
            ItemStack item = target.getInventory().getItem(slot);
            if (item.getType().isAir() || item.getItemMeta() == null) {
                this.module.sendPrefixed(MESSAGE_ERROR_NO_ITEM, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%slot%", () -> Lang.EQUIPMENT_SLOT.getLocalized((Enum)slot)));
                return;
            }
            Enchantment enchant = arguments.getEnchantment(ARG_ENCHANT);
            int level = arguments.getInt(ARG_LEVEL);
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
                storageMeta.addStoredEnchant(enchant, level, true);
                item.setItemMeta((ItemMeta)storageMeta);
            } else {
                meta.addEnchant(enchant, level, true);
                item.setItemMeta(meta);
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(MESSAGE_ENCHANTED_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%type%", () -> Lang.EQUIPMENT_SLOT.getLocalized((Enum)slot)).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)item)).with("%name%", () -> LangUtil.getSerializedName((Enchantment)enchant)).with("%amount%", () -> LangUtil.getEnchantmentLevelLang((int)level)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_ENCHANTED_NOTIFY, (CommandSender)target, replacer -> replacer.with("%type%", () -> Lang.EQUIPMENT_SLOT.getLocalized((Enum)slot)).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)item)).with("%name%", () -> LangUtil.getSerializedName((Enchantment)enchant)).with("%amount%", () -> LangUtil.getEnchantmentLevelLang((int)level)));
            }
        });
    }

    private boolean disenchantSlot(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            boolean hasEnchant;
            EquipmentSlot slot = (EquipmentSlot)arguments.get(ARG_SLOT, EquipmentSlot.class);
            ItemStack item = target.getInventory().getItem(slot);
            if (item.getType().isAir() || item.getItemMeta() == null) {
                this.module.sendPrefixed(MESSAGE_ERROR_NO_ITEM, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%slot%", () -> Lang.EQUIPMENT_SLOT.getLocalized((Enum)slot)));
                return;
            }
            ItemMeta meta = item.getItemMeta();
            Enchantment enchant = arguments.contains(ARG_ENCHANT) ? arguments.getEnchantment(ARG_ENCHANT) : null;
            boolean bl = hasEnchant = enchant != null;
            if (hasEnchant) {
                EnchantmentStorageMeta storageMeta;
                boolean isEnchanted;
                boolean bl2 = isEnchanted = meta instanceof EnchantmentStorageMeta && (storageMeta = (EnchantmentStorageMeta)meta).hasStoredEnchant(enchant) || meta.hasEnchant(enchant);
                if (!isEnchanted) {
                    this.module.sendPrefixed(MESSAGE_ERROR_NO_ENCHANT, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)item)).with("%slot%", () -> Lang.EQUIPMENT_SLOT.getLocalized((Enum)slot)).with("%enchantment%", () -> LangUtil.getSerializedName((Enchantment)enchant)));
                    return;
                }
            }
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
                if (hasEnchant) {
                    storageMeta.removeStoredEnchant(enchant);
                } else {
                    storageMeta.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)storageMeta).removeStoredEnchant(arg_0));
                }
            } else if (hasEnchant) {
                meta.removeEnchant(enchant);
            } else {
                meta.removeEnchantments();
            }
            item.setItemMeta(meta);
            if (target != context.getSender()) {
                this.module.sendPrefixed(hasEnchant ? MESSAGE_DISENCHANTED_SPECIFIC_FEEDBACK : MESSAGE_DISENCHANTED_ALL_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%slot%", () -> Lang.EQUIPMENT_SLOT.getLocalized((Enum)slot)).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)item)).with("%enchantment%", () -> hasEnchant ? LangUtil.getSerializedName((Enchantment)enchant) : ""));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(hasEnchant ? MESSAGE_DISENCHANTED_SPECIFIC_NOTIFY : MESSAGE_DISENCHANTED_ALL_NOTIFY, (CommandSender)target, replacer -> replacer.with("%slot%", () -> Lang.EQUIPMENT_SLOT.getLocalized((Enum)slot)).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)item)).with("%enchantment%", () -> hasEnchant ? LangUtil.getSerializedName((Enchantment)enchant) : ""));
            }
        });
    }
}

