/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;

public class CondenseCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("condense");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Condense.Desc").text("Condense items into blocks.");
    private static final MessageLocale MESSAGE_NOTHING = LangEntry.builder((String)"Command.Condense.Error.Nothing").chatMessage(Sound.ENTITY_VILLAGER_NO, new String[]{TagWrappers.GRAY.wrap("Nothing to condense.")});
    private static final MessageLocale MESSAGE_NOT_ENOUGH = LangEntry.builder((String)"Command.Condense.Error.NotEnough").chatMessage(TagWrappers.GRAY.wrap("Not enough items to convert " + TagWrappers.RED.wrap("%source%") + " to " + TagWrappers.RED.wrap("%result%") + ". Need at least " + TagWrappers.RED.wrap("%amount%") + "."));
    private static final MessageLocale MESSAGE_DONE = LangEntry.builder((String)"Command.Condense.Done").chatMessage(TagWrappers.GRAY.wrap("Converted " + TagWrappers.SOFT_YELLOW.wrap("x%total% %source%") + " to " + TagWrappers.SOFT_YELLOW.wrap("x%amount% %result%") + "."));
    private final EssentialModule module;

    public CondenseCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("condense", true, new String[]{"condense"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).playerOnly()).executes(this::execute));
    }

    private boolean execute(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        boolean done = false;
        HashSet<Material> userItems = new HashSet<Material>();
        for (ItemStack userItem : player.getInventory().getContents()) {
            if (userItem == null || userItem.getType().isAir()) continue;
            userItems.add(userItem.getType());
        }
        for (Material userMaterial : userItems) {
            int amountCraftMin;
            ItemStack userItem = new ItemStack(userMaterial);
            int amountPerCraft = 0;
            ItemStack recipeResult = null;
            Iterator iter = this.plugin.getServer().recipeIterator();
            block2: while (iter.hasNext()) {
                Recipe recipe = (Recipe)iter.next();
                if (!(recipe instanceof ShapedRecipe)) continue;
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                Collection recipeItems = shapedRecipe.getIngredientMap().values();
                String[] shape = shapedRecipe.getShape();
                if (shape.length < 2) continue;
                for (String line : shape) {
                    if (line.length() != shape.length) continue block2;
                }
                int amountPerRecipe = 0;
                for (ItemStack srcItem : recipeItems) {
                    if (srcItem == null || srcItem.getType().isAir()) continue;
                    if (!srcItem.isSimilar(userItem)) continue block2;
                    amountPerRecipe += srcItem.getAmount();
                }
                if (amountPerRecipe <= amountPerCraft) continue;
                amountPerCraft = amountPerRecipe;
                recipeResult = recipe.getResult();
            }
            if (amountPerCraft <= 1) continue;
            int amountUserHas = Players.countItem((Player)player, (ItemStack)userItem);
            int amountCraftCan = (int)((double)amountUserHas / (double)amountPerCraft);
            if (amountCraftCan < (amountCraftMin = recipeResult.getAmount())) {
                int finalAmountPerCraft = amountPerCraft;
                ItemStack finalRecipeResult = recipeResult;
                this.module.sendPrefixed(MESSAGE_NOT_ENOUGH, context.getSender(), builder -> builder.with("%amount%", () -> String.valueOf(finalAmountPerCraft)).with("%source%", () -> ItemUtil.getItemName((ItemStack)userItem)).with("%result%", () -> ItemUtil.getItemName((ItemStack)finalRecipeResult)));
                continue;
            }
            for (int craft = 0; craft < amountCraftCan; ++craft) {
                Players.takeItem((Player)player, (ItemStack)userItem, (int)amountPerCraft);
                Players.addItem((Player)player, (ItemStack[])new ItemStack[]{recipeResult});
            }
            ItemStack finalRecipeResult1 = recipeResult;
            int finalAmountPerCraft1 = amountPerCraft;
            this.module.sendPrefixed(MESSAGE_DONE, context.getSender(), builder -> builder.with("%source%", () -> ItemUtil.getItemName((ItemStack)userItem)).with("%result%", () -> ItemUtil.getItemName((ItemStack)finalRecipeResult1)).with("%total%", () -> String.valueOf(amountCraftCan * finalAmountPerCraft1)).with("%amount%", () -> String.valueOf(amountCraftMin * amountCraftCan)));
            done = true;
        }
        if (!done) {
            this.module.sendPrefixed(MESSAGE_NOTHING, context.getSender());
        }
        return true;
    }
}

