/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialPerms;

public class BroadcastCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("broadcast");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Broadcast.Desc").text("Broadcast a message.");
    private final String format;

    public BroadcastCommandProvider(@NotNull SunLightPlugin plugin, @NotNull List<String> format) {
        super(plugin);
        this.format = String.join((CharSequence)TagWrappers.BR, format);
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("broadcast", true, new String[]{"broadcast", "bc"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_TEXT.text())}).executes(this::broadcast));
    }

    private boolean broadcast(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String text = arguments.getString("text");
        String message = this.format.replace("%message%", text);
        NightComponent component = NightMessage.parse((String)message);
        Players.getOnline().forEach(player -> Players.sendMessage((CommandSender)player, (NightComponent)component));
        Players.sendMessage((CommandSender)this.plugin.getServer().getConsoleSender(), (NightComponent)component);
        return true;
    }
}

