/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential;

import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.integration.permission.PermissionBridge;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.essential.EssentialLang;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialProperties;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.module.essential.command.AirCommandProvider;
import su.nightexpress.sunlight.module.essential.command.BroadcastCommandProvider;
import su.nightexpress.sunlight.module.essential.command.CondenseCommandProvider;
import su.nightexpress.sunlight.module.essential.command.DimensionCommandProvider;
import su.nightexpress.sunlight.module.essential.command.DisposalCommandProvider;
import su.nightexpress.sunlight.module.essential.command.EnchantCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.ExperienceCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.FireTicksCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.FlyCommandProvider;
import su.nightexpress.sunlight.module.essential.command.FlySpeedCommandProvider;
import su.nightexpress.sunlight.module.essential.command.FoodLevelCommandProvider;
import su.nightexpress.sunlight.module.essential.command.ForceRunCommandProvider;
import su.nightexpress.sunlight.module.essential.command.ForceSayCommandProvider;
import su.nightexpress.sunlight.module.essential.command.GamemodeCommandProvider;
import su.nightexpress.sunlight.module.essential.command.HatCommandProvider;
import su.nightexpress.sunlight.module.essential.command.HealthCommandProvider;
import su.nightexpress.sunlight.module.essential.command.InvulnerabilityCommandProvider;
import su.nightexpress.sunlight.module.essential.command.NearCommandProvider;
import su.nightexpress.sunlight.module.essential.command.NickCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.PlayerInfoCommandProvider;
import su.nightexpress.sunlight.module.essential.command.PlayerTimeCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SkullCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SmiteCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SpeedCommandProvider;
import su.nightexpress.sunlight.module.essential.command.StaffCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SuicideCommandProvider;
import su.nightexpress.sunlight.module.essential.command.TeleportCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.TimeCommandProvider;
import su.nightexpress.sunlight.module.essential.command.WeatherCommandProvider;
import su.nightexpress.sunlight.module.essential.listener.EssentialListener;
import su.nightexpress.sunlight.module.essential.listener.InvulnerabilityListener;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class EssentialModule
extends Module {
    private final TeleportManager teleportManager;
    private final EssentialSettings settings;

    public EssentialModule(@NotNull ModuleContext context, @NotNull TeleportManager teleportManager) {
        super(context);
        this.teleportManager = teleportManager;
        this.settings = new EssentialSettings();
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        UserPropertyRegistry.register(EssentialProperties.CUSTOM_NAME);
        ((SunLightPlugin)this.plugin).injectLang(EssentialLang.class);
        this.settings.load(config);
        this.registerCommands();
        this.addListener((SimpeListener)new EssentialListener((SunLightPlugin)this.plugin, this));
        if (this.settings.isInvulnerabilityEnabled()) {
            this.addListener((SimpeListener)new InvulnerabilityListener((SunLightPlugin)this.plugin, this, this.settings));
        }
    }

    @Override
    protected void unloadModule() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(EssentialPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        if (this.settings.isInvulnerabilityEnabled()) {
            this.commandRegistry.addProvider("ess-invulnerability", new InvulnerabilityCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        }
        if (PermissionBridge.hasProvider()) {
            this.commandRegistry.addProvider("staff", new StaffCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        }
        this.commandRegistry.addProvider("air", new AirCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("broadcast", new BroadcastCommandProvider((SunLightPlugin)this.plugin, (List)this.settings.broadcastFormat.get()));
        this.commandRegistry.addProvider("condense", new CondenseCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("dimension", new DimensionCommandProvider((SunLightPlugin)this.plugin, this, this.userManager, this.teleportManager));
        this.commandRegistry.addProvider("disposal", new DisposalCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        this.commandRegistry.addProvider("enchant", new EnchantCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("experience", new ExperienceCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("fireticks", new FireTicksCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("fly", new FlyCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("flyspeed", new FlySpeedCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("foodlevel", new FoodLevelCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("forcerun", new ForceRunCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("forcesay", new ForceSayCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("gamemode", new GamemodeCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("hat", new HatCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("health", new HealthCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("near", new NearCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("nickname", new NickCommandsProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("playerinfo", new PlayerInfoCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("skull", new SkullCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("smite", new SmiteCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("speed", new SpeedCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("suicide", new SuicideCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("teleport", new TeleportCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager, this.teleportManager));
        this.commandRegistry.addProvider("time", new TimeCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        this.commandRegistry.addProvider("playertime", new PlayerTimeCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        this.commandRegistry.addProvider("weather", new WeatherCommandProvider((SunLightPlugin)this.plugin, this));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
        if (this.settings.isInvulnerabilityEnabled()) {
            registry.register("essential_invulnerability_state", (player, payload) -> CoreLang.STATE_ENABLED_DISALBED.get(player.isInvulnerable()));
            registry.register("essential_invulnerability_bool", (player, payload) -> String.valueOf(player.isInvulnerable()));
            registry.register("essential_custom_name", (player, payload) -> this.getCustomName(player));
        }
    }

    public @NonNull String getCustomName(@NonNull Player player) {
        SunUser user = (SunUser)this.userManager.getOrFetch(player);
        return user.getPropertyOr(EssentialProperties.CUSTOM_NAME, user.getName());
    }

    public void setCustomName(@NonNull SunUser user, @Nullable String name) {
        if (name == null) {
            user.removeProperty(EssentialProperties.CUSTOM_NAME);
        } else {
            user.setProperty(EssentialProperties.CUSTOM_NAME, name);
        }
        user.player().ifPresent(this::updatePlayerName);
        user.markDirty();
    }

    public void updatePlayerName(@NotNull Player player) {
        SunUser user = (SunUser)this.userManager.getOrFetch(player);
        if (!player.hasPermission(NickCommandsProvider.NICK_CHANGE)) {
            user.removeProperty(EssentialProperties.CUSTOM_NAME);
        }
        if (user.hasProperty(EssentialProperties.CUSTOM_NAME)) {
            String customName = user.getPropertyOrDefault(EssentialProperties.CUSTOM_NAME);
            EntityUtil.setCustomName((Entity)player, (String)customName);
        } else {
            EntityUtil.setCustomName((Entity)player, (NightComponent)null);
        }
    }
}

