/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.deathmessages;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bridge.RegistryType;
import su.nightexpress.nightcore.util.text.tag.Tags;
import su.nightexpress.sunlight.module.deathmessages.DeathMessage;

public class DeathMessagesSettings
extends AbstractConfig {
    private static final ConfigType<DeathMessage> DEATH_MESSAGE_CONFIG_TYPE = ConfigType.of(DeathMessage::read, FileConfig::set);
    private final ConfigProperty<Map<DamageType, DeathMessage>> damageTypeMessages = this.addProperty(ConfigTypes.forMap(str -> (DamageType)BukkitThing.getByString((RegistryType)RegistryType.DAMAGE_TYPE, (String)str), BukkitThing::getAsString, DEATH_MESSAGE_CONFIG_TYPE), "Messages.Damage-Type", DeathMessagesSettings.getDefaultsByType(), new String[]{""});
    private final ConfigProperty<Map<EntityType, DeathMessage>> entityTypeMessages = this.addProperty(ConfigTypes.forMap(str -> (EntityType)BukkitThing.getByString((RegistryType)RegistryType.ENTITY_TYPE, (String)str), BukkitThing::getAsString, DEATH_MESSAGE_CONFIG_TYPE), "Messages.Causing-Entity", DeathMessagesSettings.getDefaultsByEntity(), new String[]{""});

    @NotNull
    public Map<DamageType, DeathMessage> getDamageTypeMessages() {
        return (Map)this.damageTypeMessages.get();
    }

    @NotNull
    public Map<EntityType, DeathMessage> getEntityTypeMessages() {
        return (Map)this.entityTypeMessages.get();
    }

    @NotNull
    private static Map<DamageType, DeathMessage> getDefaultsByType() {
        String skull = "(" + Tags.LIGHT_RED.enclose("\u2620") + ") ";
        String swords = "(" + Tags.LIGHT_RED.enclose("\u2694") + ") ";
        HashMap<DamageType, DeathMessage> map = new HashMap<DamageType, DeathMessage>();
        map.put(DamageType.EXPLOSION, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " blowed up!")));
        map.put(DamageType.CACTUS, new DeathMessage(Lists.newList((Object[])new String[]{Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " tried to obtain some water from cactus."), Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " died when accidiently touch a cactus.")})));
        map.put(DamageType.CRAMMING, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " trampled into the ground by a crowd.")));
        map.put(DamageType.DRAGON_BREATH, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " was incinerated by a Dragon Breath.")));
        map.put(DamageType.DROWN, new DeathMessage(Lists.newList((Object[])new String[]{Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " drowned."), Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " forgot how to swim.")})));
        map.put(DamageType.MOB_ATTACK, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " was slain by " + Tags.LIGHT_RED.enclose("%source%") + ".")));
        map.put(DamageType.MOB_PROJECTILE, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " was shot by a " + Tags.LIGHT_RED.enclose("%source%") + ".")));
        map.put(DamageType.ARROW, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " was shot by a " + Tags.LIGHT_RED.enclose("%source%") + ".")));
        map.put(DamageType.PLAYER_ATTACK, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%source%") + " killed " + Tags.LIGHT_RED.enclose("%player_display_name%") + ".")));
        map.put(DamageType.FALL, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " fell from a high spot.")));
        map.put(DamageType.FALLING_ANVIL, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " was unable to hold an Anvil.")));
        map.put(DamageType.FLY_INTO_WALL, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " exceeded the speed limit with elytras.")));
        map.put(DamageType.IN_FIRE, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " burned to the ground.")));
        map.put(DamageType.ON_FIRE, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " burned to the ground.")));
        map.put(DamageType.FREEZE, new DeathMessage(Lists.newList((Object[])new String[]{Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " frozen to death."), Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " fell asleep in the snow.")})));
        map.put(DamageType.HOT_FLOOR, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " walked too long on Magma Blocks.")));
        map.put(DamageType.LAVA, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " tried to swim in lava.")));
        map.put(DamageType.LIGHTNING_BOLT, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " was shot by a Lightning.")));
        map.put(DamageType.MAGIC, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " killed by a deadly magic.")));
        map.put(DamageType.SONIC_BOOM, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + "''s eardrums were exploded.")));
        map.put(DamageType.STARVE, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " forgot to eat.")));
        map.put(DamageType.IN_WALL, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " was buried alive.")));
        map.put(DamageType.THORNS, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " died when touching " + Tags.LIGHT_RED.enclose("%source%") + ".")));
        return map;
    }

    @NotNull
    private static Map<EntityType, DeathMessage> getDefaultsByEntity() {
        String skull = "(" + Tags.LIGHT_RED.enclose("\u2620") + ") ";
        String swords = "(" + Tags.LIGHT_RED.enclose("\u2694") + ") ";
        HashMap<EntityType, DeathMessage> map = new HashMap<EntityType, DeathMessage>();
        map.put(EntityType.TNT, DeathMessage.simple(Tags.GRAY.enclose(skull + Tags.LIGHT_RED.enclose("%player_display_name%") + " lost his limbs due to TNT explosion!")));
        map.put(EntityType.BEE, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " attempted to steal honey from Bees.")));
        map.put(EntityType.BLAZE, new DeathMessage(Lists.newList((Object[])new String[]{Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " could not reflect Blaze''s fireball."), Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " catched a fireball with his head.")})));
        map.put(EntityType.CAVE_SPIDER, new DeathMessage(Lists.newList((Object[])new String[]{Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " was bited to death by a little spidee."), Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " climb down too deep in a cave with Spiders.")})));
        map.put(EntityType.DROWNED, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " was drowned by Drowned.")));
        map.put(EntityType.GHAST, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " was fireballed by a Ghast.")));
        map.put(EntityType.ENDERMAN, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " looked strange at Enderman.")));
        map.put(EntityType.ZOMBIE, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + "''s brain was eaten by Zombie.")));
        map.put(EntityType.ZOMBIE_VILLAGER, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " tried to talk with Zombie Villager.")));
        map.put(EntityType.PIGLIN, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " offered a very bad trade to Piglin.")));
        map.put(EntityType.CREEPER, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " could not run away from a Creeper in time.")));
        map.put(EntityType.SKELETON, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " was shot by a skeleton.")));
        map.put(EntityType.WITHER, DeathMessage.simple(Tags.GRAY.enclose(swords + Tags.LIGHT_RED.enclose("%player_display_name%") + " could not beat Wither.")));
        return map;
    }
}

