/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.deathmessages;

import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.EventUtils;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.exception.ModuleLoadException;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.deathmessages.DeathContext;
import su.nightexpress.sunlight.module.deathmessages.DeathMessage;
import su.nightexpress.sunlight.module.deathmessages.DeathMessagesListener;
import su.nightexpress.sunlight.module.deathmessages.DeathMessagesSettings;

public class DeathMessagesModule
extends Module {
    private final DeathMessagesSettings settings = new DeathMessagesSettings();

    public DeathMessagesModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) throws ModuleLoadException {
        this.settings.load(config);
        this.addListener((SimpeListener)new DeathMessagesListener((SunLightPlugin)this.plugin, this));
    }

    @Override
    protected void unloadModule() {
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    public void handleDeathEvent(@NotNull PlayerDeathEvent event) {
        DeathContext context;
        DeathMessage message;
        EventUtils.getAdapter().setDeathMessage(event, null);
        Player player = event.getEntity();
        EntityDamageEvent lastEvent = player.getLastDamageCause();
        if (lastEvent == null) {
            return;
        }
        DamageSource damageSource = lastEvent.getDamageSource();
        Entity causingEntity = damageSource.getCausingEntity();
        Entity directEnttiy = damageSource.getDirectEntity();
        ItemStack weapon = null;
        if (causingEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)causingEntity;
            weapon = EntityUtil.getItemInSlot((LivingEntity)livingEntity, (EquipmentSlot)EquipmentSlot.HAND);
        }
        if ((message = this.getMessage(context = new DeathContext(player, damageSource, causingEntity, directEnttiy, weapon))) == null) {
            return;
        }
        String rawMessage = message.selectMessage();
        if (rawMessage == null) {
            return;
        }
        PlaceholderContext.Builder builder = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver((Object)context.player())).andThen(CommonPlaceholders.forPlaceholderAPI((Player)context.player()));
        if (causingEntity != null) {
            builder.with("%source%", () -> DeathMessagesModule.getName(causingEntity));
            builder.with("%item%", () -> DeathMessagesModule.getItemName(causingEntity));
        }
        String deathMessage = builder.build().apply(rawMessage);
        EventUtils.getAdapter().setDeathMessage(event, NightMessage.parse((String)deathMessage));
    }

    @Nullable
    public DeathMessage getMessage(@NotNull DeathContext context) {
        DeathMessage deathMessage = null;
        Entity causingEntity = context.causingEntity();
        Entity directEnttiy = context.directEntity();
        if (directEnttiy != null) {
            deathMessage = this.settings.getEntityTypeMessages().get(directEnttiy.getType());
        }
        if (causingEntity != null && deathMessage == null) {
            deathMessage = this.settings.getEntityTypeMessages().get(causingEntity.getType());
        }
        if (deathMessage == null) {
            deathMessage = this.settings.getDamageTypeMessages().get(context.damageSource().getDamageType());
        }
        return deathMessage;
    }

    @NotNull
    private static String getName(@NotNull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Players.getDisplayNameSerialized((Player)player);
        }
        return EntityUtil.getNameSerialized((Entity)entity);
    }

    @NotNull
    private static String getItemName(@NotNull Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return "";
        }
        LivingEntity living = (LivingEntity)entity;
        EntityEquipment equipment = living.getEquipment();
        if (equipment == null) {
            return "";
        }
        ItemStack item = equipment.getItemInMainHand();
        return ItemUtil.getNameSerialized((ItemStack)item);
    }
}

