/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.rule;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.LowerCase;

public class TrieNode {
    private final Map<Character, TrieNode> children = new HashMap<Character, TrieNode>();
    private boolean isEnd;

    public void add(@NotNull String word) {
        String lowered = LowerCase.USER_LOCALE.apply(word);
        TrieNode node = this;
        for (char c : lowered.toCharArray()) {
            node = node.children.computeIfAbsent(Character.valueOf(c), k -> new TrieNode());
        }
        node.isEnd = true;
    }

    @Nullable
    public TrieNode children(char c) {
        return this.children.get(Character.valueOf(c));
    }

    public boolean isEnd() {
        return this.isEnd;
    }
}

