/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.processor.global;

import org.apache.commons.text.similarity.JaroWinklerSimilarity;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.cache.CachedContent;
import su.nightexpress.sunlight.module.chat.context.ChatContext;
import su.nightexpress.sunlight.module.chat.core.ChatLang;
import su.nightexpress.sunlight.module.chat.processor.ChatProcessor;

public class AntiFloodProcessor
implements ChatProcessor<ChatContext> {
    private boolean floodDetected;

    @Override
    public void preProcess(@NotNull ChatModule module, @NotNull ChatContext context) {
        Player player = context.getPlayer();
        CachedContent lastContent = context.getLastContent();
        if (lastContent == null || lastContent.isExpired()) {
            return;
        }
        double threshold = module.getSettings().getAntiFloodSimilarityScoreThreshold();
        if (!this.isSimilarEnough(context.getMessage(), lastContent.content(), threshold)) {
            return;
        }
        this.floodDetected = true;
        int score = lastContent.getCount();
        if (score >= module.getSettings().getAntiFloodSimilarityCountThreshold()) {
            module.sendPrefixed(ChatLang.ANTI_FLOOD_SIMILAR_CONTENT, (CommandSender)player);
            context.cancel();
            return;
        }
        lastContent.addCount();
    }

    @Override
    public void postProcess(@NotNull ChatModule module, @NotNull ChatContext context) {
        if (this.floodDetected) {
            return;
        }
        int lifeTime = module.getSettings().getUserContentCacheLifetime();
        if (lifeTime <= 0) {
            return;
        }
        context.setLastContent(context.getMessage(), lifeTime);
    }

    private boolean isSimilarEnough(@NotNull String left, @NotNull String right, double similarityThreshold) {
        double threshold;
        double score = AntiFloodProcessor.getSimiliartyScore(left, right);
        return score >= (threshold = similarityThreshold / 100.0);
    }

    public static double getSimiliartyScore(@NotNull String left, @NotNull String right) {
        JaroWinklerSimilarity similarity = new JaroWinklerSimilarity();
        return similarity.apply((CharSequence)left, (CharSequence)right);
    }
}

